#pragma once
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

// library version of Alnwlsn's 2019 Soviet Block Game
// Alnwlsn 2025

#define sv_size_x 10  // width; gameboy version is 10
#define sv_size_y 18 // height; gameboy version is 18

#define sv_lineclear_ani_frameskip 5        // number of frames to show blink cycle of cleared lines
#define sv_level0_frames 50                 //(at level 0) number of frames to wait before advancing piece down by 1
#define sv_das_first 10                     // how many frames you need to hold a direction down to make it go in that direction repeatedly
#define sv_das_subsequent sv_das_first - 1  // load value of das counter when direction is held. sets "repeat rate"; higher = faster

// this is the screen where the blocks are. You should iterate over it to draw.
extern uint8_t sv_blockarea[sv_size_x][sv_size_y];
// this is the section which shows the next piece
extern uint8_t sv_nextarea[4][4];

void sv_init();

extern bool sv_is_gameover;     // true if game over
extern int sv_level;            // sv_LEVEL
extern unsigned int sv_lines;   // NUMBER OF sv_LINES CLEARED
extern unsigned long sv_score;  // TOTAL sv_SCORE (using NES rules)

// inside sv_blockarea are colors set for each piece, defined as:
// 0 - black/background
// 1 - long one        (cyan)
// 2 - backwards L     (blue)
// 3 - L               (orange)
// 4 - S shape         (green)
// 5 - T shape         (magenta)
// 6 - reverse S shape (red)
// 7 - square          (yellow)
// 8 - white

// player controls
void sv_up();
void sv_down();
void sv_left();
void sv_right();
void sv_rcw();   // rotate clockwise
void sv_rccw();  // rotate counter-clockwise

void sv_nextlevel();  // advance to next level (test)

void sv_newgame();

void sv_calculate();  // calculates the next frame (not the next step) of the game
