#include <SDL2/SDL.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "font.h"
#include "soviet.h"

#define WINDOW_INIT_X 240 + sv_size_x * 24
#define WINDOW_INIT_Y 48 + sv_size_y * 24

SDL_Window* window = NULL;
SDL_Renderer* renderer = NULL;

int sqx = 0;
int sqy = 0;
char buf[128];

int sv_level_last = 0;
unsigned int sv_lines_last = 0;
unsigned long sv_score_last = 0;

void draw_square(int x, int y, int color) {
  switch (color) {
    default:
    case 0:
      SDL_SetRenderDrawColor(renderer, 16, 16, 16, 255);
      break;
    case 1:
      SDL_SetRenderDrawColor(renderer, 0, 128, 128, 255);
      break;
    case 2:
      SDL_SetRenderDrawColor(renderer, 0, 64, 128, 255);
      break;
    case 3:
      SDL_SetRenderDrawColor(renderer, 128, 64, 0, 255);
      break;
    case 4:
      SDL_SetRenderDrawColor(renderer, 0, 128, 0, 255);
      break;
    case 5:
      SDL_SetRenderDrawColor(renderer, 128, 0, 128, 255);
      break;
    case 6:
      SDL_SetRenderDrawColor(renderer, 128, 0, 0, 255);
      break;
    case 7:
      SDL_SetRenderDrawColor(renderer, 128, 128, 0, 255);
      break;
    case 8:
      SDL_SetRenderDrawColor(renderer, 128, 128, 128, 255);
      break;
  }
  SDL_Rect square = {x * 24 + 24, (sv_size_y - 1 - y) * 24 + 24, 24, 24};  // x, y, w, h
  SDL_RenderFillRect(renderer, &square);
}

void print_font(int x, int y, char* st) {
  int o = 0;
  while (1) {
    if (*st == 0) break;
    for (int j = 0; j <= 11; j++) {
      for (int i = 0; i <= 7; i++) {
        bool c = (font[(11 - j) + (16 * (*st))] >> (7 - i)) & 1;
        if (c) {
          SDL_SetRenderDrawColor(renderer, 128, 128, 128, 255);
        } else {
          SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
        }
        SDL_Rect square = {x + (i * 2) + (o * 12), (y) + ((11 - j) * 2), 2, 2};  // x, y, w, h
        SDL_RenderFillRect(renderer, &square);
      }
    }
    o++;
    st++;
  }
}

int main() {
  SDL_Init(SDL_INIT_VIDEO);
  window = SDL_CreateWindow("Soviet Block", SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, WINDOW_INIT_X, WINDOW_INIT_Y,
                            SDL_WINDOW_SHOWN | SDL_WINDOW_RESIZABLE);  //| SDL_WINDOW_MAXIMIZED);
  renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED | SDL_RENDERER_TARGETTEXTURE);

  int quit = 0;
  SDL_Event e;

  bool j_held = 0;
  bool k_held = 0;
  bool l_held = 0;
  bool i_held = 0;
  bool a_held = 0;
  bool s_held = 0;

  sv_init();

  while (!quit) {
    sv_calculate();

    for (int i = 0; i < sv_size_x; i++) {
      for (int j = 0; j < sv_size_y; j++) {
        int color = sv_blockarea[i][j];
        draw_square(i, j, color);
      }
    }

    for (int i = 0; i < 4; i++) {
      for (int j = 0; j < 4; j++) {
        int color = sv_nextarea[i][j];
        draw_square(i + sv_size_x + 1, j + sv_size_y - 4, color);
      }
    }

    print_font((sv_size_x + 2) * 24, 140, "Score");
    print_font((sv_size_x + 2) * 24, 200, "Level");
    print_font((sv_size_x + 2) * 24, 260, "Lines");
    // if (sv_score_last != sv_score) {
    //   sv_score_last = sv_score;
    sprintf(buf, "%010ld", sv_score);
    print_font((sv_size_x + 2) * 24, 160, buf);
    // }
    // if (sv_level_last != sv_level) {
    //   sv_level_last = sv_level;
    sprintf(buf, "%02d", sv_level);
    print_font((sv_size_x + 2) * 24, 220, buf);
    // }
    // if (sv_lines_last != sv_lines) {
    //   sv_lines_last = sv_lines;
    sprintf(buf, "%04d", sv_lines);
    print_font((sv_size_x + 2) * 24, 280, buf);
    // }

    while (SDL_PollEvent(&e)) {
      switch (e.type) {
        case SDL_QUIT:
          quit = 1;
          break;
        case SDL_KEYUP:
          switch (e.key.keysym.sym) {
            case SDLK_j:
              j_held = 0;
              break;
            case SDLK_k:
              k_held = 0;
              break;
            case SDLK_l:
              l_held = 0;
              break;
            case SDLK_i:
              i_held = 0;
              break;
            case SDLK_a:
              a_held = 0;
              break;
            case SDLK_s:
              s_held = 0;
              break;
          }
          break;
        case SDL_KEYDOWN:
          switch (e.key.keysym.sym) {
            case SDLK_q:
              quit = 1;
              break;
            case SDLK_w:
              SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);
              SDL_RenderClear(renderer);
              break;
            case SDLK_z:
              draw_square(sqx, sqy, 1);
              break;
            case SDLK_x:
              draw_square(sqx, sqy, sqx);
              break;
            case SDLK_f:
              sqx -= 1;
              break;
            case SDLK_t:
              sqy += 1;
              break;
            case SDLK_g:
              sqy -= 1;
              break;
            case SDLK_h:
              sqx += 1;
              break;
            case SDLK_j:
              j_held = 1;
              break;
            case SDLK_k:
              k_held = 1;
              break;
            case SDLK_l:
              l_held = 1;
              break;
            case SDLK_i:
              i_held = 1;
              break;
            case SDLK_u:
              sv_rcw();
              break;
            case SDLK_o:
              sv_rccw();
              break;
            case SDLK_a:
              a_held = 1;
              break;
            case SDLK_s:
              s_held = 1;
              break;
            case SDLK_n:
              sv_newgame();
              break;
            case SDLK_p:
              sv_nextlevel();
              break;
            case SDLK_b:
              sv_blockarea[3][3] = 1;
              break;
          }
          break;
      }
    }
    if (j_held) sv_left();
    if (k_held) sv_down();
    if (i_held) sv_up();
    if (l_held) sv_right();
    if (a_held) sv_rccw();
    if (s_held) sv_rcw();
    SDL_RenderPresent(renderer);
    SDL_Delay(16);  // ~60fps
  }

  SDL_DestroyRenderer(renderer);
  SDL_DestroyWindow(window);
  SDL_Quit();
}