FUNCTION setupTimer#(frequency#) 'Returns the actual frequency that was set
IF (frequency# > 1193181) OR (frequency# < 18.3) THEN ERROR 5 'Illegal function call
ticksPerTimer& = 1193181# / frequency#
OUT &H43, &H34 'Specifies a bitmask setting the timer style and initializing the ports for receiving a clock rate
OUT &H40, ticksPerTimer& AND 255 'Send low 8 bits first
OUT &H40, ticksPerTimer& \ 256 'Then send high 8 bits
setupTimer# = 1193181 / ticksPerTimer& 'And finally, return the resulting clock rate
END FUNCTION

SUB unSetupTimer() 'Returns the timer to normal operation
OUT &H43, &H34
OUT &H40, 0 'Set low 8 bits of trigger to 0
OUT &H40, 0 'Set high 8 bits of trigger to 0
END SUB