String header="<!DOCTYPE html><html><head><style>a{color:#f3bf00;}body{background-color:#000000;color:#f3bf00;}table{border-collapse:collapse;}td,th{border: 1px solid #f3bf00;}input[type=text]{background-color:#000000;color:#00ff00;border:none;width:6em;}input[type=submit]{background-color:#000000;color:#f3bf00;border:1px solid #f3bf00}</style></head><body>";
String footer="</body></html>";

void OTAupdate(){   //SET THE ESP8266 TO RECIVE FIRMWARE UPDATES VIA ARDUINOOTA
  server.sendHeader(F("Connection"), F("close"));
  server.sendHeader(F("Access-Control-Allow-Origin"), F("*"));
  server.send(200, F("text/html"), F("<html><body bgcolor=\"90c4da\">Server offline. Please send firmware update file (via ArduinoOTA).<br><a href=\"/\">return</a></body></html>"));
  //ArduinoOTA.setHostname("esp8266-1");
  ArduinoOTA.begin();
  while(1){
    ArduinoOTA.handle();
    delay(0);
  }
}

void pageRoot(){    //The main page. Has varoius tables and forms
  String content=header;
  content+=F("<h2>Status:</h2><p>");
  content+=F("<form action=\"/time\" method=\"get\">Unix time: <input type=\"text\" style=\"border:1px solid #f3bf00\" name=\"utc\" value=\"");content+=String(unixoffset+millis()/1000);content+=F("\"><input type=\"submit\" value=\"Set\">     ");
  content+=String(ux.year());content+=F("-");content+=String(ux.month());content+=F("-");content+=String(ux.day());content+=F(" ");content+=String(ux.hour());content+=F(":");content+=String(ux.minute());content+=F(":");content+=String(ux.second());
  content+=F("</form></p>");
  
  content+=F("<p><form action=\"/settings2\" method=\"get\">");
  content+=F("<input type=\"checkbox\" name=\"useSpg\" value=\"1\" "); if(useSGP4){content+=F("checked=\"checked\"");} content+=F(">SGP4 output --> Input3<br>");
  content+=F("<input type=\"submit\" value=\"Set\"></form></p>");
  
  content+=F("<p><form action=\"/settings1\" method=\"get\">");
    content+=F("<table><tr><th>Motor</th><th>Raw pos.</th>");
    content+=F("<th><input type=\"checkbox\" name=\"ctotal\" value=\"1\" "); if(ctotal){content+=F("checked=\"checked\"");} content+=F(">Total</th>");
    content+=F("<th><input type=\"checkbox\" name=\"cinp1\" value=\"1\" "); if(cinp1){content+=F("checked=\"checked\"");} content+=F(">Input1</th>");
    content+=F("<th><input type=\"checkbox\" name=\"cinp2\" value=\"1\" "); if(cinp2){content+=F("checked=\"checked\"");} content+=F(">Input2</th>");
    content+=F("<th><input type=\"checkbox\" name=\"cinp3\" value=\"1\" "); if(cinp3){content+=F("checked=\"checked\"");} content+=F(">Input3</th>");
    content+=F("</tr><tr><td>Azimuth</td>");
      content+=F("<td><input type=\"text\" name=\"rawB\" value=\"");content+=String(sm.currentPositionB());content+=F("\"></td>");
      content+=F("<td>");content+=String(Btotal);content+=F("</td>");
      content+=F("<td><input type=\"text\" name=\"Binp1\" value=\"");content+=String(Binp1);content+=F("\"></td>");
      content+=F("<td><input type=\"text\" name=\"Binp2\" value=\"");content+=String(Binp2);content+=F("\"></td>");
      content+=F("<td><input type=\"text\" name=\"Binp3\" value=\"");content+=String(Binp3);content+=F("\"></td>");
      content+=F("</tr>");
    content+=F("<tr><td>Elevation</td>");
      content+=F("<td><input type=\"text\" name=\"rawA\" value=\"");content+=String(sm.currentPositionA());content+=F("\"></td>");
      content+=F("<td>");content+=String(Atotal);content+=F("</td>");
      content+=F("<td><input type=\"text\" name=\"Ainp1\" value=\"");content+=String(Ainp1);content+=F("\"></td>");
      content+=F("<td><input type=\"text\" name=\"Ainp2\" value=\"");content+=String(Ainp2);content+=F("\"></td>");
      content+=F("<td><input type=\"text\" name=\"Ainp3\" value=\"");content+=String(Ainp3);content+=F("\"></td>");
      content+=F("</tr>");
  content+=F("</table><br><input type=\"submit\" name=\"sn\" value=\"Mode\"><input type=\"submit\" name=\"sn\" value=\"DefineRaw\"><input type=\"submit\" name=\"sn\" value=\"SetRaw\"><input type=\"submit\" name=\"sn\" value=\"SetInputs\"></form></p>");

  content+=F("<p>Location information:<br><form action=\"/location\" method=\"get\"><table><tr><td>Latitude</td><td><input type=\"text\" name=\"latitude\" value=\"");content+=String(sLatitude, 7);content+=F("\"></td></tr>");
  content+=F("<tr><td>Longitude</td><td><input type=\"text\" name=\"longitude\" value=\"");content+=String(sLongitude, 7);content+=F("\"></td></tr>");
  content+=F("<tr><td>Altitude</td><td><input type=\"text\" name=\"altitude\" value=\"");content+=String(sAltitude);content+=F("\"></td></tr></table><br><input type=\"submit\" name=\"sn\" value=\"Set\"></form>");

  content+=F("<p>Current TLE:<br><pre>"); content+=tle_satname; content+=F("\r\n"); content+=tle_line1; content+=F("\r\n"); content+=tle_line2; content+=F("</pre></p>");
  
  content += F("<p><b>Loaded TLEs:</b>");
  if(SPIFFS.exists(tlefile)){
    File f = SPIFFS.open(tlefile, "r");
    int tleEntries = f.size()/168;
    for(int i = 0; i <= tleEntries-1; i++){
      content += F("<br><a href=\"/satpick?sat=");content+=String(i);content+=F("\">");
      for(byte j = 0; j <= 23; j++){ content += char(f.read()); } //24 char satilite name
      f.read(); f.read(); //end of line indicators
      for(byte j = 0; j <= 68; j++){ /*content += char(f.read());*/ f.read(); } //69 char line 1
      f.read(); f.read(); //end of line indicators
      for(byte j = 0; j <= 68; j++){ /*content += char(f.read());*/ f.read(); } //69 char line 2
      f.read(); f.read();
      content += F("</a>");
    }
    f.close();
  }
  content += F("</p>");
  
  //the file/upload table
  content += F("<h2>Files</h2><p><table><tr><th>Delete</th><th>Size</th><th>Filename</th><th>TLE</th></tr>");  //List files
  Dir dir = SPIFFS.openDir(F("/"));
  while (dir.next()){
   String fileName = dir.fileName();
   //Serial.println(fileName);
   size_t fileSize = dir.fileSize();
   content += F("<tr><td><a href=\"/delete?n="); content += fileName;     //make delate link
   content += F("\">rm</a></td><td>");           content += fileSize;     //print file size
   content += F("</td><td><a href=\"");          content += fileName;     //make a link to the file
   content += F("\">");                          content += fileName;
   content += F("</a></td><td><a href=\"/loadtle?n="); content += fileName;     //make tle link
   content += F("\">load</a></td></tr>");
  }content += F("</table><a href=\"uploader\">Upload File</a></p>");

  
  content+=footer;
  server.sendHeader(F("Connection"), F("close"));
  server.sendHeader(F("Access-Control-Allow-Origin"), F("*"));
  server.send(200, F("text/html"), content);
}
void pageUploader(){
  String content=header;
  content+=F("<form method='POST' action='/upload' enctype='multipart/form-data'><input type='file' name='payload'><input type='submit' value='Upload'></form>");
  content+=footer;
  server.sendHeader(F("Connection"), F("close"));
  server.sendHeader(F("Access-Control-Allow-Origin"), F("*"));
  server.send(200, F("text/html"), content);
}
void reToRoot(){    //sends a redirect back to /
  server.sendHeader(F("Connection"), F("close"));
  server.sendHeader(F("Access-Control-Allow-Origin"), F("*"));
  server.send(200, F("text/html"), F("<html><head><meta http-equiv=\"refresh\" content=\"0; url=/\" /></head><body bgcolor=\"000000\"></body></html>"));
}
void pageSettings1(){
  String setting = server.arg(F("sn")); //setting type
  if(setting.equals(F("Mode"))){
    String temp = server.arg(F("mode")); motorMode=temp.toInt();
  }
  if(setting.equals(F("DefineRaw"))){
    String tempA = server.arg(F("rawA")); sm.defineCurrentPositionA(tempA.toInt());
    String tempB = server.arg(F("rawB")); sm.defineCurrentPositionB(tempB.toInt());
  }
  if(setting.equals(F("SetRaw"))){
    String temp = server.arg(F("rawA")); sm.toPositionA(temp.toInt());
           temp = server.arg(F("rawB")); sm.toPositionB(temp.toInt());
  }
  if(setting.equals(F("SetInputs"))){
    String temp = server.arg(F("Ainp1")); Ainp1=temp.toFloat();
    temp = server.arg(F("Binp1")); Binp1=temp.toFloat();
    temp = server.arg(F("Ainp2")); Ainp2=temp.toFloat();
    temp = server.arg(F("Binp2")); Binp2=temp.toFloat();
    temp = server.arg(F("Ainp3")); Ainp3=temp.toFloat();
    temp = server.arg(F("Binp3")); Binp3=temp.toFloat();
  }
  ctotal=server.arg(F("ctotal")).toInt();
  cinp1=server.arg(F("cinp1")).toInt();
  cinp2=server.arg(F("cinp2")).toInt();
  cinp3=server.arg(F("cinp3")).toInt();
  reToRoot();
}
void pageSettings2(){
  useSGP4=server.arg(F("useSpg")).toInt();
  reToRoot();
}
void pageLocation(){
  String temp = server.arg(F("latitude")); sLatitude=temp.toFloat();
  temp = server.arg(F("longitude")); sLongitude=temp.toFloat();
  temp = server.arg(F("altitude")); sAltitude=temp.toFloat();
  reToRoot();
  sat.site(sLatitude,sLongitude,sAltitude);      //set site latitude[°], longitude[°] and altitude[m]
  sat.init(tle_satname,tle_line1,tle_line2); 
  sat.findsat(unixoffset+millis()/1000);

}
void pageTime(){
  String temp = server.arg(F("utc")); 
  unixoffset=temp.toInt()-millis()/1000;
  reToRoot();
}
void pageLoadTLE(){ //Set the tle file
  tlefile = server.arg(F("n"));
  reToRoot();
}
void pageSatpick(){ //gets TLE from selection
  String sitem = server.arg(F("sat"));
  int item = sitem.toInt();
  if(SPIFFS.exists(tlefile)){
    File f = SPIFFS.open(tlefile, "r");
    for(int i = 0; i <= item*168-1; i++){f.read();} //read until the part of the file we want
      for(byte j = 0; j <= 23; j++){ tle_satname[j] = f.read(); } //24 char satilite name
      f.read(); f.read(); //end of line indicators
      for(byte j = 0; j <= 68; j++){ tle_line1[j] = f.read(); } //168 char line 1
      f.read(); f.read(); //end of line indicators
      for(byte j = 0; j <= 68; j++){ tle_line2[j] = f.read(); } //168 char line 2
      f.close();
    }
  sat.init(tle_satname,tle_line1,tle_line2); 
  sat.findsat(unixoffset+millis()/1000);
  reToRoot();
}

void handleFileUpload(){
  if(server.uri() != F("/upload")){ return; }                  //kick out if not submitted to /upload
  HTTPUpload& upload = server.upload();
  if(upload.status == UPLOAD_FILE_START){
    String path = upload.filename;
    if(!path.startsWith(F("/"))){ path = "/"+path; }           //add a leading / if there isn't one }
    if(SPIFFS.exists(path)){ SPIFFS.remove(path); }
    fsUploadFile = SPIFFS.open(path, "w");
    path = String();                                           //make path a null string
  } else if(upload.status == UPLOAD_FILE_WRITE){
    if(fsUploadFile){ fsUploadFile.write(upload.buf, upload.currentSize); }
  } else if(upload.status == UPLOAD_FILE_END){
    if(fsUploadFile){ fsUploadFile.close(); }
  }
}
void handleFileRead(){
  String path = server.uri();
  String contentType = getContentType(path);
  if(SPIFFS.exists(path)){                                     //if the file is there
    File file = SPIFFS.open(path, "r");                        //open it
    size_t sent = server.streamFile(file, contentType);        //send it
    file.close();                                              //close the file
  } else {
  server.sendHeader(F("Connection"), F("close"));
  server.sendHeader(F("Access-Control-Allow-Origin"), F("*"));
  server.send(404, F("text/plain"), F("File not found."));     //else hand out a 404
  }
}
void pageDelete(){ String path = server.arg(F("n")); if(SPIFFS.exists(path)){ SPIFFS.remove(path); } reToRoot(); } //delete a file
String getContentType(String filename){
  if(server.hasArg(F("download"))){ return F("application/octet-stream");}
  else if(filename.endsWith(F(".htm"))){ return F("text/html");}
  else if(filename.endsWith(F(".html"))){ return F("text/html");}
  else if(filename.endsWith(F(".css"))){ return F("text/css");}
  else if(filename.endsWith(F(".js"))){ return F("application/javascript");}
  else if(filename.endsWith(F(".png"))){ return F("image/png");}
  else if(filename.endsWith(F(".gif"))){ return F("image/gif");}
  else if(filename.endsWith(F(".jpg"))){ return F("image/jpeg");}
  else if(filename.endsWith(F(".ico"))){ return F("image/x-icon");}
  else if(filename.endsWith(F(".xml"))){ return F("text/xml");}
  else if(filename.endsWith(F(".pdf"))){ return F("application/x-pdf");}
  else if(filename.endsWith(F(".zip"))){ return F("application/x-zip");}
  else if(filename.endsWith(F(".gz"))){ return F("application/x-gzip");}
  return F("text/plain");  //if none of the file extensions match, assume text/plain
}

void initServer(){
  server.on("/", HTTP_GET, pageRoot);
  server.on("/OTAupdate", HTTP_GET, OTAupdate);
  server.on("/settings1", HTTP_GET, pageSettings1);
  server.on("/settings2", HTTP_GET, pageSettings2);
  server.on("/time", HTTP_GET, pageTime);
  server.on("/loadtle", HTTP_GET, pageLoadTLE);
  server.on("/location", HTTP_GET, pageLocation);
  server.on("/satpick", HTTP_GET, pageSatpick);
  
  server.onFileUpload(handleFileUpload);          //UPLOAD FILES - 
  server.on("/upload", HTTP_POST, reToRoot);
  server.on("/uploader", HTTP_GET, pageUploader);
  server.on("/delete", HTTP_GET, pageDelete);
  server.onNotFound(handleFileRead);              //DOWNLOAD FILES - onNotFound called when the url is not defined here. use it to load content from SPIFFS
  server.begin();                               
}
