#include "BYJStepper595.h" //easily drives stepper motors with shift register
BYJstepper sm(12,15,13,4);

#include "uxtime.h"        //converts between timestamp and unix time
uxtime ux;
uint32_t unixoffset; //number of seconds to add to millis to get unix time

#include <Sgp4.h>          //satelite calculations
Sgp4 sat;
char tle_satname[25] = "ISS (ZARYA)";
char tle_line1[70] = "1 25544U 98067A   18083.85150497  .00009599  00000-0  15205-3 0  9997";  //Line one from the TLE data
char tle_line2[70] = "2 25544  51.6418  79.1515 0001348 249.8848 189.4068 15.54129545105401";  //Line two from the TLE data
float sLatitude=44.8177;
float sLongitude=-84.9733;
float sAltitude=371;
bool useSGP4=0;
uint32_t currentSecond=0;
uint32_t currentMillis=0;
float startAz;
float endAz;
float startEl;
float endEl;

#include <MPU9255.h>
MPU9255 mpu;
float compass=0;
int mxMin;
int mxMax;
int myMin;
int myMax;
bool useCompass=0;

#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
#include <WiFiUdp.h>
#include <ArduinoOTA.h>
#include <FS.h>
File fsUploadFile;
ESP8266WebServer server(80); // server object
const char* wssid = "2N3904";
const char* wpassword = "19771977";

//************************Angles*************************
float Atotal=0;
float Btotal=0;
float Ainp1=0;
float Binp1=0;
float Ainp2=0;
float Binp2=0;
float Ainp3=0;
float Binp3=0;

bool cinp1=0; //enables or disable input to be added to motor position
bool cinp2=0; 
bool cinp3=0;
bool ctotal=0;

//*********************************FOR WEBPAGE USE************************
byte motorMode=0;
int moveSteps=0; 
String tlefile = "/amateur.txt";
String currentSat;

void setup(){
  Serial.begin(115200);
  SPIFFS.begin();
  mpu.init();
  //MAKE WIFI CONNECTION ************************************************************
  
  Serial.print(F("Connecting to ")); Serial.println(wssid);
  WiFi.begin(wssid, wpassword);
  byte tcycle=0;
  while(WiFi.status() != WL_CONNECTED && tcycle < 15) {
    delay(1000);
    tcycle++;
  }
  if(WiFi.status() != WL_CONNECTED){
    //WiFi.disconnect();
    Serial.println(F("SSID not found, using internal AP"));
    WiFi.mode(WIFI_AP);
    WiFi.softAP("esp8266-1", "19771977");
  }
  Serial.print(F("Connected. IP: ")); Serial.println(WiFi.localIP());
  sm.setLockA(0);
  sm.setLockB(0);
  sm.moveStepsA(32);sm.moveStepsA(-32);
  sm.moveStepsB(32);sm.moveStepsB(-32);

  sat.site(sLatitude,sLongitude,sAltitude);      //set site latitude[°], longitude[°] and altitude[m]
  sat.init(tle_satname,tle_line1,tle_line2);     //initialize satellite parameters 
  
  initServer();
}

void loop(){
  server.handleClient();
  delay(0);
  ux.calc(unixoffset+millis()/1000);
  mpu.read_mag();
  compass=compass*.9995+.0005*(180/3.14159)*atan2(cMagY(),cMagX());

  if(currentSecond!=(unixoffset+millis()/1000)){
    currentSecond=(unixoffset+millis()/1000);
    currentMillis=millis();
    sat.findsat(unixoffset+1+millis()/1000);
    endAz=sat.satAz; endEl=sat.satEl;
    sat.findsat(unixoffset+millis()/1000);
    startAz=sat.satAz; startEl=sat.satEl;  
  }
  
  if(useSGP4){
    Binp3 = ((endAz-startAz)/1000)*(millis()-currentMillis)+startAz; 
    Ainp3 = ((endEl-startEl)/1000)*(millis()-currentMillis)+startEl;
  }

  if(useCompass){Binp2 = compass;}
  
  Atotal=0; Btotal=0;
  if(cinp1){Atotal+=Ainp1; Btotal+=Binp1;}
  if(cinp2){Atotal+=Ainp2; Btotal+=Binp2;}
  if(cinp3){Atotal+=Ainp3; Btotal+=Binp3;}
  if(ctotal){motorA(Atotal); motorB(Btotal);}
}


void motorA(float rawangle){
  while(rawangle>180){rawangle-=360;}
  while(rawangle<=-180){rawangle+=360;}
  int global=map(rawangle*10, -1800,1800,-1024,1024);
  sm.toPositionA(global);
}
void motorB(float rawangle){
  while(rawangle>=360){rawangle-=360;}
  while(rawangle<0){rawangle+=360;}
  int global=map(rawangle*10, 0,3600,0,2047);
  sm.toPositionB(global);
}

void calibrateMag(unsigned long mtime){
  unsigned long startmillis=millis();
  mxMax=-100000;
  mxMin=100000;
  myMax=-100000;
  myMin=100000;
  while(startmillis+mtime>millis()){
    mpu.read_mag();
    delay(1);
    if(mpu.mx>mxMax){mxMax=mpu.mx;}
    if(mpu.mx<mxMin){mxMin=mpu.mx;}
    if(mpu.my>myMax){myMax=mpu.my;}
    if(mpu.my<myMin){myMin=mpu.my;}
  }
}

int cMagX(){
  int temp = mpu.mx;
  temp=constrain(temp, mxMin, mxMax);
  return map(temp, mxMin, mxMax, -1000, 1000);
}

int cMagY(){
  int temp = mpu.my;
  temp=constrain(temp, myMin, myMax);
  return map(temp, myMin, myMax, -1000, 1000);
}

