//conversions between hardware raw values and usable degrees

void motorA(float rawangle){
  while(rawangle>180){rawangle-=360;}
  while(rawangle<=-180){rawangle+=360;}
  int global=map(rawangle*10, -1800,1800,-1024,1024);
  sm.toPositionB(global);
}
void motorB(float rawangle){
  while(rawangle>=360){rawangle-=360;}
  while(rawangle<0){rawangle+=360;}
  int global=map(rawangle*10, 0,3600,0,2047);
  sm.toPositionA(global);
}

//Compass
void calibrateMag(unsigned long mtime){
  unsigned long startmillis=millis();
  mxMax=-100000;
  mxMin=100000;
  myMax=-100000;
  myMin=100000;
  while(startmillis+mtime>millis()){
    mpu.read_mag();
    delay(1);
    if(mpu.mx>mxMax){mxMax=mpu.mx;}
    if(mpu.mx<mxMin){mxMin=mpu.mx;}
    if(mpu.my>myMax){myMax=mpu.my;}
    if(mpu.my<myMin){myMin=mpu.my;}
  }
}

int cMagX(){
  int temp = mpu.mx;
  temp=constrain(temp, mxMin, mxMax);
  return map(temp, mxMin, mxMax, -1000, 1000);
}

int cMagY(){
  int temp = mpu.my;
  temp=constrain(temp, myMin, myMax);
  return map(temp, myMin, myMax, -1000, 1000);
}
