#include "math.h"
class Planets{
    double pi=3.14159265358979323846264338327950288419716939937510;
    double wunixj2k=946728000;
    uint64_t wunixts;
    double wRA; //right ascention
    double wDE; //declimation
    double wLat; //local Earth coordinates of observer
    double wLon;
    
    double wAZ; //azimuth
    double wEL; //elevation
    
    double wBm; //ecliptic beta (latitude)
    double wLm; //ecliptic lambda (longitude)
	
	//planet  Osculating Elements store
	double oI, oO, oP, oA, oN, oE, oL;
	int64_t oU; 
	double wHpX, wHpY, wHpZ; //Heliocentric coordinates for planet and Earth
	double wHeX, wHeY, wHeZ;	
	
    
    public:
    Planets(){}
    void setTime(uint64_t temp){ wunixts=temp; }
    void setLocation(double tLat, double tLon){ wLat=tLat; wLon=tLon; }
    void setEquatorial(double tRA, double tDE){ wRA=tRA; wDE=tDE; }
    
    double azimuth(){return wAZ;}
    double elevation(){return wEL;} 
    
    void ecl2equ(){
        double wT = (wunixts-wunixj2k)/(3155760000L);
        double wEcl = 23.439291666666666 - (46.815/3600)*wT - (0.0006/3600)*pow(wT,2) + (0.00181/3600)*pow(wT,3);
        wRA = (180/pi)*atan2((sin((pi/180)*wLm)*cos((pi/180)*wEcl)-tan((pi/180)*wBm)*sin((pi/180)*wEcl)),cos((pi/180)*wLm));
        wRA = wRA-floor(wRA/360)*360;
        wDE = (180/pi)*asin(sin((pi/180)*wBm)*cos((pi/180)*wEcl)+cos((pi/180)*wBm)*sin((pi/180)*wEcl)*sin((pi/180)*wLm));   
    }
    void equ2hor(){
        double wLST = 100.46 + 0.985647 * ((wunixts-wunixj2k)/86400) + wLon + 15*((wunixts-floor(wunixts/86400)*86400)/3600);
               wLST = wLST - floor(wLST/360)*360;    
        double wHA = (wLST - wRA + 360);
               wHA = wHA-floor(wHA/360)*360;
        double wx = cos(wHA * (pi / 180)) * cos(wDE * (pi / 180));
        double wy = sin(wHA * (pi / 180)) * cos(wDE * (pi / 180));
        double wz = sin(wDE * (pi / 180));
        double wxhor = wx * cos((90 - wLat) * (pi / 180)) - wz *sin((90 - wLat) * (pi / 180));
        double wyhor = wy;
        double wzhor = wx * sin((90 - wLat) * (pi / 180)) + wz *cos((90 - wLat) * (pi / 180));
        wAZ = atan2(wyhor, wxhor) * (180 / pi) + 180;
        wEL = asin(wzhor) * (180 / pi);
    }
    void calculateSun(){
        //from Practical Astronomy with your Calculator or Spreadsheet, Fourth Edition
        //using epoch of 2010
        double wSuneg = 279.557208; //"orbital" parameters
        double wSunwg = 283.112438;
        double wSune  = 0.016705;
        double wunixepoch = 1262217600; //date of epoch (2010)
        
        double wD = (wunixts-wunixepoch)/86400;
        double wSunN = (360/365.242191)*wD;
               wSunN = wSunN-floor(wSunN/360)*360;
        double wSunMo = wSunN + wSuneg - wSunwg;
               wSunMo = wSunMo-floor(wSunMo/360)*360;
        double wSunEc = (360/pi)*wSune*sin(wSunMo*(pi/180));
        double wSunLm = wSunN + wSunEc + wSuneg;
               wSunLm = wSunLm-floor(wSunLm/360)*360;
        wLm = wSunLm;
        wBm = 0;
        ecl2equ();
        equ2hor();
    }
	void calculateMoon(){
		double wSuneg = 279.557208;
		double wSunwg = 283.112438;
		double wSune  = 0.016705;
		double wMoonLo = 91.929336;
		double wMoonPo = 130.143076;
		double wMoonNo = 291.682547;
		double wMooni  = 5.145396;
		double wMoone  = 0.0549;
		double wMoona = 384401;
		double wMoonTho = 0.5181;
		double wMoonPro = 0.9507;
		double wunixepoch = 1262217600; //2010

		double wD = (wunixts-wunixepoch)/86400;
		double wSunN = (360/365.242191)*wD;
	    wSunN = wSunN-floor(wSunN/360)*360;
		double wSunMo = wSunN + wSuneg - wSunwg;
		wSunMo = wSunMo-floor(wSunMo/360)*360;
		double wSunec = (360/pi)*wSune*sin(wSunMo*(pi/180));
		double wSunLm = wSunN + wSunec + wSuneg;
		wSunLm = wSunLm-floor(wSunLm/360)*360;
		double wMoonL = 13.1763966*wD + wMoonLo;
		wMoonL = wMoonL-floor(wMoonL/360)*360;
		double wMoonMm = wMoonL - 0.111404*wD - wMoonPo;
		wMoonMm = wMoonMm-floor(wMoonMm/360)*360;
		double wMoonN = wMoonNo - 0.0529539*wD;
		wMoonN = wMoonN-floor(wMoonN/360)*360;
		double wMoonEv = 1.2739*sin((pi/180)*(2*(wMoonL-wSunLm)-wMoonMm));
		double wMoonAe  = 0.1858*sin((pi/180)*wSunMo);
		double wMoonAth = 0.39*sin((pi/180)*wSunMo);
		double wMoonMpm = wMoonMm + wMoonEv - wMoonAe - wMoonAth;
		double wMoonEc = 6.2886*sin((pi/180)*wMoonMpm);
		double wMoonAfo = 0.214*sin((pi/180)*2*wMoonMpm);
		double wMoonLp = wMoonL + wMoonEv + wMoonEc - wMoonAe + wMoonAfo;
		double wMoonV = 0.6583*sin((pi/180)*2*(wMoonLp-wSunLm));
		double wMoonLpp = wMoonLp + wMoonV;
		double wMoonNp = wMoonN - 0.16*sin((pi/180)*wSunMo);
		double wMoony = sin((pi/180)*(wMoonLpp - wMoonNp))*cos((pi/180)*(wMooni));
		double wMoonx = cos((pi/180)*(wMoonLpp - wMoonNp));
		double wMoonLmm = wMoonNp + (180/pi)*atan2(wMoony,wMoonx);
		double wMoonBm = (180/pi)*asin(sin((pi/180)*(wMoonLpp-wMoonNp))*sin((pi/180)*wMooni));
		wLm = wMoonLmm;
		wBm = wMoonBm;
		ecl2equ();
        equ2hor();
	}
	void calculateMercury(){
		calculateEarthHel(); //find out where the earth is first
		oI = 7.0052;  //Load mars orbital elements
		oO = 48.493;
		oP = 77.669;
		oA = 0.387098;
		oN = 4.09235;
		oE = 0.205645;
		oL = 93.8725;
		oU = 1376611200;    //epoch is aug 16, 2013
		calculatePlanetLocal(); //calculate the rest, and find the local AZ and EL
	}
	void calculateVenus(){
		calculateEarthHel(); //find out where the earth is first
		oI = 3.3949;  //Load mars orbital elements
		oO = 76.804;
		oP = 131.99;
		oA = 0.723327;
		oN = 1.60215;
		oE = 0.006769;
		oL = 233.5729;
		oU = 1376611200;    //epoch is aug 16, 2013
		calculatePlanetLocal(); //calculate the rest, and find the local AZ and EL
	}
	void calculateMars(){
		calculateEarthHel(); //find out where the earth is first
		oI = 1.8496;  //Load mars orbital elements
		oO = 49.668;
		oP = 336.322;
		oA = 1.523562;
		oN = 0.523998;
		oE = 0.093346;
		oL = 82.9625;
		oU = 1376611200;    //epoch is aug 16, 2013
		calculatePlanetLocal(); //calculate the rest, and find the local AZ and EL
	}
	void calculateJupiter(){
		calculateEarthHel(); //find out where the earth is first
		oI = 1.3033;  //Load mars orbital elements
		oO = 100.629;
		oP = 14.556;
		oA = 5.20245;
		oN = 0.083099;
		oE = 0.048892;
		oL = 87.9728;
		oU = 1376611200;    //epoch is aug 16, 2013
		calculatePlanetLocal(); //calculate the rest, and find the local AZ and EL
	}
	void calculateSaturn(){
		calculateEarthHel(); //find out where the earth is first
		oI = 2.4869;  //Load mars orbital elements
		oO = 113.732;
		oP = 91.500;
		oA = 9.52450;
		oN = 0.033551;
		oE = 0.055724;
		oL = 216.6279;
		oU = 1376611200;    //epoch is aug 16, 2013
		calculatePlanetLocal(); //calculate the rest, and find the local AZ and EL
	}
	void calculatePlanetLocal(){ //calculates RA and DEC from earth and planet Heliocentric coords.
	    calculateHel(); 
		wHpX = wHpX - wHeX;
		wHpY = wHpY - wHeY;
		wHpZ = wHpZ - wHeZ;
		//calculate Geocentric equatorial coordinates
		//wHpX = wHpX; 23.439292 = obliquity of the ecliptic; comes from fact that orbital elemets refer to J2000
		double wHY = wHpY*0.91748205589 - wHpZ*0.39777717016;
	    double wHZ = wHpY*0.39777717016 + wHpZ*0.91748205589;
		wRA = (180/pi)*atan2(-wHY,-wHpX)+180;
		wDE = (180/pi)*atan(wHZ/sqrt(pow(wHpX,2) + pow(wHY,2)));
		equ2hor();
	}
	void calculateEarthHel(){
		oI = 0;  //load earth elements
		oO = 0;
		oP = 103.147;
		oA = 1.0000;
		oN = 0.985611;
		oE = 0.016679;
		oL = 324.5489;
		oU = 1376611200; //epoch is aug 16, 2013
		calculateHel();  //calculate heliocenteric coords as if a planet
		wHeX = wHpX;
		wHeY = wHpY;
		wHeZ = wHpZ;
	}
	void calculateHel(){ //calculates Heliocentric coordinates of the planet
		//from https://paulplusx.wordpress.com/2016/03/02/rtpts_azalt/
		double wD = (wunixts-oU)/86400;
		double wM = oN*wD+oL-oP; //Mean Anomaly
		double wV = wM + (180/pi)*((2 * oE - 0.25 *pow(oE,3) + 5/96 * pow(oE,5)) * sin((pi/180)*wM) + //true anomaly
				(1.25 * pow(oE,2) - 11/24 * pow(oE,4)) * sin((pi/180)*2*wM) + 
				(13/12 * pow(oE,3) - 43/64 * pow(oE,5)) * sin((pi/180)*3*wM) + 
				103/96 * pow(oE,4) * sin((pi/180)*4*wM) + 1097/960 * pow(oE,5) * sin((pi/180)*5*wM));
		double wR = oA * (1 - pow(oE,2)) / (1 + oE * cos((pi/180)*wV)); //radius vector
		//Geocentric ecliptic coordinates
		wHpX = wR * (cos((pi/180)*oO) * cos((pi/180)*(wV + oP - oO)) - sin((pi/180)*oO) * sin((pi/180)*(wV + oP - oO)) * cos((pi/180)*oI));
		wHpY = wR * (sin((pi/180)*oO) * cos((pi/180)*(wV + oP - oO)) + cos((pi/180)*oO) * sin((pi/180)*(wV + oP - oO)) * cos((pi/180)*oI));
		wHpZ = wR * (sin((pi/180)*(wV + oP - oO)) * sin((pi/180)*oI));
	}
};