class EarthCC{
	//Earth Coordinate Calculator
	double ax;
	double ay;
	double bx;
	double by;
	double cx; //the point of the observer
	double cy; 
	double dx; 
	double dy;
	bool onPath;
	
	double gaspect;
	
	
	public:
	double GCdistPath(double ax1,double ay1,double bx1,double by1,double cx1,double cy1){
		//calculate the nearest distance to a path
		//points a and b are the two nearest points (lat/lng) on the path
		//point c is lat/lng of gps reciver
		
		//first, calculate the closest point (d) on segment formed by a and b to point c
		ax=ax1; ay=ay1; bx=bx1; by=by1; cx=cx1; cy=cy1;
		calcAspect(); //calculate the aspect ratio between lat/long grid to a square, flat distance grid
		ax=ax*gaspect; //apply the aspect ratio (which means the calculations will be done on a square grid)
		bx=bx*gaspect;
		cx=cx*gaspect;
		calcPath(); //calculate the closest point
		float lenAB = sqrt((ax-bx)*(ax-bx)+(ay-by)*(ay-by));
		float lenAD = sqrt((ax-dx)*(ax-dx)+(ay-dy)*(ay-dy));
	    float lenDB = sqrt((dx-bx)*(dx-bx)+(dy-by)*(dy-by));
		dx=dx/gaspect; //undo the aspect ratio to get back to the true lat/lon grid
		ax=ax1; ay=ay1; bx=bx1; by=by1; cx=cx1; cy=cy1; //use the original lat/lon coordinates again
		double cd = GCdist(cx, cy, dx, dy); //calculate the distance
		if(lenAD>lenAB||lenDB>lenAB){
			//not valid - point D is on line extending from AB
			onPath=0;
		}else{
			//valid - point D is on AB segment
			onPath=1;
		}
		return cd;
	}
	bool GCisOnPath(){
		return onPath;
	}
	
	void calcAspect(){
		double ddy = GCdist(cx, cy-0.01, cx, cy+0.01);
		double ddx = GCdist(cx-0.01, cy, cx+0.01, cy);
		gaspect = ddx/ddy;
	}
	
	void calcPath(){
		//calculate the closest point d on segment formed by a and b to point c
		if(ay==by){
			dy=ay;
			dx=cx;
		}else if(ax==bx){
			dy=cy;
			dx=ax;
		}else{    
			double m = (ay-by)/(ax-bx);
			double b = ay-m*ax;
			dx = (cy-b+((1/m)*cx))/((1/m)+m);
			dy = m*dx+b;
		}
	}
	
	double GCdist(double lat1, double long1, double lat2, double long2){
		//Courtesy of Maarten Lamers, borrowed from TinyGPS plus
		double delta = radians(long1-long2);
		double sdlong = sin(delta);
		double cdlong = cos(delta);
		lat1 = radians(lat1);
		lat2 = radians(lat2);
		double slat1 = sin(lat1);
		double clat1 = cos(lat1);
		double slat2 = sin(lat2);
		double clat2 = cos(lat2);
		delta = (clat1 * slat2) - (slat1 * clat2 * cdlong);
		delta = sq(delta);
		delta += sq(clat2 * sdlong);
		delta = sqrt(delta);
		double denom = (slat1 * slat2) + (clat1 * clat2 * cdlong);
		delta = atan2(delta, denom);
		return delta * 6372795;
	}
};