class BYJstepper{
  //permanant:
  uint8_t qds;  uint8_t qclock;  uint8_t qlatch;
  uint8_t topspeed;
  //status:
  int32_t mcurrentPositionA;
  uint8_t oncycleA;
  uint8_t jholdA;
  uint8_t wspeedA;
  int32_t mcurrentPositionB;
  uint8_t oncycleB;
  uint8_t jholdB;
  uint8_t wspeedB;
  uint8_t s595;
  public:
  BYJstepper(uint8_t pin1, uint8_t pin2, uint8_t pin3, uint8_t topspeed){
    qds = pin1; qclock = pin2; qlatch = pin3;
    oncycleA=0; jholdA=1;
    oncycleB=0; jholdB=1;
    wspeedA=topspeed;
    wspeedB=topspeed;
    mcurrentPositionA=0;
    mcurrentPositionB=0;
    s595=0;
    
    pinMode(qds, OUTPUT); pinMode(qclock, OUTPUT);  pinMode(qlatch, OUTPUT);
  }
  void moveStepsA(long steps){
    mcurrentPositionA+=steps;
    uint8_t direc = 0; if(steps<0){direc = 1;} steps = abs(steps); //set the direction
    while(steps>0){
      steps--;
      if(direc){
        oncycleA++; if(oncycleA==4){oncycleA=0;}
      }else{
        oncycleA--; if(oncycleA==255){oncycleA=3;}
      }
      bitWrite(s595, 0, 0); bitWrite(s595, 1, 0); bitWrite(s595, 2, 0); bitWrite(s595, 3, 0);
      switch(oncycleA){
        case 0:
          s595pin(0,1);delay(wspeedA);if(!(jholdA&&steps==0)){s595pin(0,0);}
         break;
        case 1:
          s595pin(1,1);delay(wspeedA);if(!(jholdA&&steps==0)){s595pin(1,0);}
         break;
        case 2:
          s595pin(2,1);delay(wspeedA);if(!(jholdA&&steps==0)){s595pin(2,0);}
         break;
        case 3:
          s595pin(3,1);delay(wspeedA);if(!(jholdA&&steps==0)){s595pin(3,0);}
         break;
      }
    }
  }
  long currentPositionA(){ return mcurrentPositionA; }
  void setLockA(byte byjtemp){ jholdA=byjtemp; }
  void defineCurrentPositionA(long def){ mcurrentPositionA = def; }
  void toPositionA(long gt){ gt = gt-mcurrentPositionA; this->moveStepsA(gt); }
  void motorSpeedA(byte setspeed){ wspeedA=setspeed; if(wspeedA<topspeed){wspeedA=topspeed;}}
  
  void moveStepsB(long steps){
    mcurrentPositionB+=steps;
    uint8_t direc = 0; if(steps<0){direc = 1;} steps = abs(steps); //set the direction
    while(steps>0){
      steps--;
      if(direc){
        oncycleB++; if(oncycleB==4){oncycleB=0;}
      }else{
        oncycleB--; if(oncycleB==255){oncycleB=3;}
      }
      bitWrite(s595, 4, 0); bitWrite(s595, 5, 0); bitWrite(s595, 6, 0); bitWrite(s595, 7, 0);
      switch(oncycleB){
        case 0:
          s595pin(4,1);delay(wspeedB);if(!(jholdB&&steps==0)){s595pin(4,0);}
         break;
        case 1:
          s595pin(5,1);delay(wspeedB);if(!(jholdB&&steps==0)){s595pin(5,0);}
         break;
        case 2:
          s595pin(6,1);delay(wspeedB);if(!(jholdB&&steps==0)){s595pin(6,0);}
         break;
        case 3:
          s595pin(7,1);delay(wspeedB);if(!(jholdB&&steps==0)){s595pin(7,0);}
         break;
      }
    }
  }
  long currentPositionB(){ return mcurrentPositionB; }
  void setLockB(byte byjtemp){ jholdB=byjtemp; }
  void defineCurrentPositionB(long def){ mcurrentPositionB = def; }
  void toPositionB(long gt){ gt = gt-mcurrentPositionB; this->moveStepsB(gt); }
  void motorSpeedB(byte setspeed){ wspeedB=setspeed; if(wspeedB<topspeed){wspeedB=topspeed;}}
  
  void s595pin(byte pin, byte val){
   bitWrite(s595, pin, val);
   for(byte u = 0; u<=7; u++){
     digitalWrite(qds,bitRead(s595,7-u));
     digitalWrite(qclock,1);
     digitalWrite(qclock,0);
   }
   digitalWrite(qlatch,1);
   digitalWrite(qlatch,0);
  }
};