class BYJstepper{
  //permanant:
  uint8_t in1;  uint8_t in2;  uint8_t in3;  uint8_t in4; //input pins
  uint8_t topspeed;
  //status:
  int32_t mcurrentPosition;
  uint8_t oncycle;
  uint8_t jhold;
  uint8_t wspeed;
  public:
  BYJstepper(uint8_t pin1, uint8_t pin2, uint8_t pin3, uint8_t pin4, uint8_t topspeed){
    in1 = pin1; in2 = pin2; in3 = pin3; in4 = pin4;
    oncycle=0; jhold=1;
    wspeed=topspeed;
    mcurrentPosition=0;
    pinMode(in1, OUTPUT); pinMode(in2, OUTPUT);  pinMode(in3, OUTPUT);  pinMode(in4, OUTPUT);
  }
  void moveSteps(long steps){
    mcurrentPosition+=steps;
    uint8_t direc = 0; if(steps<0){direc = 1;} steps = abs(steps); //set the direction
    while(steps>0){
      steps--;
      if(direc){
        oncycle++; if(oncycle==4){oncycle=0;}
      }else{
        oncycle--; if(oncycle==255){oncycle=3;}
      }
      digitalWrite(in1, 0);
      digitalWrite(in2, 0);
      digitalWrite(in3, 0);
      digitalWrite(in4, 0);
      switch(oncycle){
        case 0:
          digitalWrite(in1, 1);delay(wspeed);if(!(jhold&&steps==0)){digitalWrite(in1, 0);}
         break;
        case 1:
          digitalWrite(in2, 1);delay(wspeed);if(!(jhold&&steps==0)){digitalWrite(in2, 0);}
         break;
        case 2:
          digitalWrite(in3, 1);delay(wspeed);if(!(jhold&&steps==0)){digitalWrite(in3, 0);}
         break;
        case 3:
          digitalWrite(in4, 1);delay(wspeed);if(!(jhold&&steps==0)){digitalWrite(in4, 0);}
         break;
      }
    }
  }
  long currentPosition(){
    return mcurrentPosition;
  }
  void setLock(byte byjtemp){
	  jhold=byjtemp;
  }
  void defineCurrentPosition(long def){
    mcurrentPosition = def;
  }
  void toPosition(long gt){
    gt = gt-mcurrentPosition;
    this->moveSteps(gt);
  }
  void motorSpeed(byte setspeed){
    wspeed=setspeed;
    if(wspeed<topspeed){wspeed=topspeed;}
  }
};