#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x3f,16,2); 

byte state;

int count;

long stmillis; //storage for the start of each minute
byte currentsecond;

int frame[60];

int currentcount;

void setup() {
  Serial.begin(9600);
  pinMode(2, INPUT_PULLUP);
  pinMode(13, OUTPUT);
  analogReference(INTERNAL);
  pinMode(A7, INPUT);
  attachInterrupt(digitalPinToInterrupt(2), isr, FALLING);
  lcd.init();
  lcd.backlight();
}

// the loop function runs over and over again forever
void loop() {
  if(currentsecond!=kseconds()){
    currentsecond=kseconds();
    frame[currentsecond]=count;
    count=0;
    lcd.clear();
    lcd.setCursor(10,1); lcd.print(counttotal()*0.006315, 3);
    lcd.setCursor(14,0); if(currentsecond<10){lcd.print('0');} lcd.print(currentsecond); 
    lcd.setCursor(0,0); lcd.print(counttotal());
    lcd.setCursor(8,0); lcd.print(analogRead(A7)); //voltmeter conversion ADC to ~400V 
    Serial.print(F("")); Serial.print(currentsecond);  Serial.print(F(",")); Serial.print(counttotal()); Serial.print(F(",")); Serial.println(counttotal()*0.006315, 4);
  }
  if(currentcount!=count){
    currentcount=count;
    lcd.setCursor(0,1); lcd.print(count);
  }
}

void isr(){
  count++;
}

byte kseconds(){
  long jmillis = millis() - stmillis;
  if(jmillis>=60000L){stmillis = stmillis + 60000L;}
  //Serial.println(jmillis);
  return jmillis/1000;
}

long counttotal(){
  long temp=0;
  for(byte k = 0; k <= 59; k++){temp+=frame[k];}
  return temp;
}

