#include <Arduino.h>
#include <TM1637Display.h>
#define CLK 10
#define DIO 9
TM1637Display display(CLK, DIO);

#include <SendOnlySoftwareSerial.h>
SendOnlySoftwareSerial zSerial (4);

#define cpm2usv 0.006315

#define hvpwm 200
#define vref 578 //set to 400v
#define Kp 0.0
#define Ki 0.0005
float error;
float ierror;
byte hvout;

unsigned long tcount;
int count;
byte buttons;
byte mode;
#define maxmode 5
int screen;
byte zeros;
byte brightness=7;

byte currentframe;
byte frame[60];
#define frametime 60

unsigned int bluelimit=128;

unsigned long lastmillis;
#define timestep 250

float tempf1;
long templ1;


void setup() {
  zSerial.begin(9600);
  analogReference(INTERNAL1V1);
  TCCR1A = B00010001; //set timer1 to raise PWM frequency to ~4k Hz
  TCCR1B = B00001010;
  pinMode(A3, INPUT); pinMode(5, OUTPUT);//400v regulation
  pinMode(8, INPUT); attachInterrupt(digitalPinToInterrupt(8), isr, RISING); //counter

  pinMode(7, OUTPUT); digitalWrite(7, 1); //blue light

  pinMode(0, INPUT_PULLUP); pinMode(1, INPUT_PULLUP); pinMode(2, INPUT_PULLUP); 
  
  display.setBrightness(brightness);
  lastmillis = millis();
}

void loop(){
  if(millis() - lastmillis > timestep){
    lastmillis = millis();
    display.showNumberDecEx(screen, 0, zeros);
  }
  if(currentframe!=frameclock()){
    currentframe = frameclock();
    frame[currentframe]=count;
    count=0;
    tempf1 = counttotal()*cpm2usv;
    if(counttotal()>=bluelimit){digitalWrite(7,0);}else{digitalWrite(7,1);}
    zSerial.print(currentframe);zSerial.print(',');zSerial.print(counttotal());zSerial.print(',');zSerial.print(tempf1,6);zSerial.print(',');zSerial.println(tcount);
  }
  updatevolt();
  
  if(bitRead(buttons, 0)){
    mode++;
    if(mode>maxmode){mode = 0;}
    display.showNumberDecEx(mode, 64, 0);
    while(bitRead(buttons, 0)){
      updatevolt();
    }
  }

  switch(mode){
    case 0:
     zeros = 0;
     screen = counttotal();
     if(bitRead(buttons, 1)){screen = frameclock();}
     if(bitRead(buttons, 2)){for(byte k = 0; k <= frametime-1; k++){frame[k]=0;}}
     break;
    case 1:
     zeros = 1;
     templ1 = tempf1 * 10000L; templ1=templ1%10000L;
     screen = templ1;
     if(bitRead(buttons, 1)){screen = tempf1;}
     break;
    case 2:
     zeros = 1;
     screen = tcount%10000;
     if(bitRead(buttons, 1)){screen = tcount/10000;}
     if(bitRead(buttons, 2)){tcount = 0;}
     break;
    case 3:
     zeros = 0;
     screen = brightness;
     if(bitRead(buttons, 2)){brightness--; if(brightness>7){brightness=7;} display.setBrightness(brightness); while(bitRead(buttons, 2)){updatevolt();}}
     if(bitRead(buttons, 1)){brightness++; if(brightness>7){brightness=0;} display.setBrightness(brightness); while(bitRead(buttons, 1)){updatevolt();}}
     break;
    case 4:
     zeros = 0;
     screen = hvout;
     if(bitRead(buttons, 1)){screen = analogRead(A3);}
     break;
    case 5:
     screen = bluelimit;
     if(bitRead(buttons, 2)){bluelimit=bluelimit/2; while(bitRead(buttons, 2)){updatevolt();}}
     if(bitRead(buttons, 1)){bluelimit=bluelimit*2; while(bitRead(buttons, 1)){updatevolt();}}
     break;
  }
  
}

void isr(){
  if(count >= 255){count--;} //limit
  count++;
  tcount++;
}

void updatevolt(){
  bitWrite(buttons, 0, !digitalRead(1));bitWrite(buttons, 1, !digitalRead(0));bitWrite(buttons, 2, !digitalRead(2));
  
  error = vref - analogRead(A3);
  ierror+=error;
  hvout = error*Kp + ierror*Ki;
  if(hvout >= 200){ierror=0; error=0; hvout=0;}
  analogWrite(5, hvout);
  delayMicroseconds(100);
}

byte frameclock(){
  return (millis()/1000)%60;
}

long counttotal(){
  long temp=0;
  for(byte k = 0; k <= frametime-1; k++){temp+=frame[k];}
  return temp;
}

void smartDelay(unsigned long ms){         //delay and update voltage
  unsigned long start = millis();
  do{
    updatevolt();
  }while (millis() - start < ms);
}
