#include <Arduino.h>
#include <TM1637Display.h>
#define CLK 10
#define DIO 9
TM1637Display display(CLK, DIO);

#define hvpwmlim 200
#define voltage 578 //set to 400v
byte hvpwm = 0;

//#include <SendOnlySoftwareSerial.h>
//SendOnlySoftwareSerial zSerial (4);

int count;

long stmillis; //storage for the start of each minute
byte currentsecond;

int frame[60];

void setup() {
  //zSerial.begin(9600);
  
  analogReference(INTERNAL1V1);
  TCCR1A = B00010001; //set timer1 to raise PWM frequency to ~4k Hz
  TCCR1B = B00001010;
  pinMode(A3, INPUT); pinMode(5, OUTPUT);//400v regulation
  pinMode(8, INPUT); attachInterrupt(digitalPinToInterrupt(8), isr, RISING); //counter

  pinMode(7, OUTPUT); digitalWrite(7, 1); //blue light

  pinMode(0, INPUT_PULLUP); pinMode(1, INPUT_PULLUP); pinMode(2, INPUT_PULLUP);

  
  display.setBrightness(255);
}

void loop(){
  int k = analogRead(A3);
  if(voltage > k){ hvpwm++; if(hvpwm >= hvpwmlim){hvpwm=hvpwmlim;} analogWrite(5,hvpwm); }
  if(voltage < k){ hvpwm--; if(hvpwm >= 255     ){hvpwm=0;       } analogWrite(5,hvpwm); }
  if(currentsecond!=kseconds()){
    //display.showNumberDecEx(analogRead(A6)*0.52636, 0, 0);
    currentsecond=kseconds();
    frame[currentsecond]=count;
    count=0;
    if(counttotal()>=1000){digitalWrite(7, 0);}else{digitalWrite(7, 1);}
    //zSerial.print(currentsecond);  zSerial.print(','); zSerial.print(counttotal()); zSerial.print(','); zSerial.println(counttotal()*0.006315, 4);
  }
  display.showNumberDecEx(100*digitalRead(2)+10*digitalRead(0)+digitalRead(1), 0, 1);
  delayMicroseconds(100);
}

void isr(){
  count++;
}

byte kseconds(){
  long jmillis = millis() - stmillis;
  if(jmillis>=60000L){stmillis = stmillis + 60000L;}
  //Serial.println(jmillis);
  return jmillis/1000;
}

long counttotal(){
  long temp=0;
  for(byte k = 0; k <= 59; k++){temp+=frame[k];}
  return temp;
}
