#include <avr/power.h>
#include <avr/sleep.h>
#include <Wire.h>
#include <SPIMemory.h>
#include <simpleds3231.h>

#define powerBus 8 //pin for the power bus
                   //pin 2 is interrupt for clock to reactivate atmega
                   //pins 10-13 are spi pins for flash
                   //pins a4 a5 are i2c pins

SPIFlash flash;
DS3231 rtc;

struct frame_t{  //structure that stores each frame
  unsigned long cycle;      //4 bytes
  unsigned long timestanp;  //4 bytes
  float tempeReading;       //4
  float baromReading;       //4
  float humidReading;       //4 -- TOTAL: 20
  byte checksum;
};

frame_t frame;
unsigned long lastindex;
unsigned long startindex;
unsigned long index;

byte  keep_SPCR;
byte  keep_ADCSRA;


void setup() {
  pinMode(A5, INPUT); pinMode(A4, INPUT);
  pinMode(powerBus, OUTPUT); digitalWrite(powerBus, LOW); delay(500);
  DDRB  &= ~((1<<DDB5) | (1<<DDB4) | (1<<DDB3) | (1<<DDB2));   // set All SPI pins to INPUT
  PORTB &= ~((1<<DDB5) | (1<<DDB4) | (1<<DDB3) | (1<<DDB2));   // remove resistors (pins low)
  DDRB  |=  ((1<<DDB5) | (1<<DDB3) | (1<<DDB2));               // set SCLK(D13), MOSI(D11) & SS(D10) as OUTPUT

  Serial.begin(9600);
  Serial.println(sizeof(frame));
  flash.begin(MB(4));
  Serial.println(F("TIME CAPSULE LONG DURATION ENVIROMENTAL LOGGER - Alan J. WIlson 2018"));
  lastindex=flash.getCapacity()/sizeof(frame);
  Serial.print(F("Flash capacity: "));Serial.print(flash.getCapacity()); Serial.print(F(" bytes, "));Serial.print(lastindex); Serial.println(F(" frames"));
  //Serial.println(F("Erasing Chip")); flash.eraseChip();

  Serial.print(F("Finding next ram index: "));
  while(1){
    if(!flash.readAnything(startindex*sizeof(frame), frame)){Serial.print(F("Read failed!"));}
    if(frame.cycle==4294967295){break;}
    startindex++;
  } Serial.println(startindex);
  
  /*for (unsigned long i = 0; i <= 100000 ; i++) {
    Serial.print(i);
    Serial.print(' ');
    if(flash.writeLong(i * 4, i)){Serial.println(F("OK"));}else{Serial.println(F("N"));}
  }*/

  keep_SPCR=SPCR; 
  keep_ADCSRA=ADCSRA;  
}

void loop() {
  //***************************************************POWER ON SECTION*******************************************************
  digitalWrite(powerBus, LOW); //turn on power bus
  DDRB  |=  ((1<<DDB5) | (1<<DDB3) | (1<<DDB2));   // set SCLK(D13), MOSI(D11) & SS(D10) as OUTPUT
  power_spi_enable();                              // enable the SPI clock 
  SPCR=keep_SPCR;                                  // enable SPI peripheral
  ADCSRA=keep_ADCSRA;                              // turn back ADCs
  delay(100);
  //***************************************************SENSOR READ SECTION***************************************************
  flash.begin(MB(4));
  //***************************************************POWER OFF SECTION******************************************************
  delay(10);
  keep_SPCR=SPCR;                                              // save SPI state
  SPCR = 0;                                                    // disable SPI
  power_spi_disable();                                         // disable SPI clock
  DDRB  &= ~((1<<DDB5) | (1<<DDB4) | (1<<DDB3) | (1<<DDB2));   // set All SPI pins to INPUT
  PORTB &= ~((1<<DDB5) | (1<<DDB4) | (1<<DDB3) | (1<<DDB2));   // remove resistors
  digitalWrite(powerBus, HIGH);                                //turn off power bus
  //*********************************SLEEP*************************
  keep_ADCSRA=ADCSRA;
  ADCSRA = 0;                                       //disable ADCS
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts();                                   //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING);                //goto 'wake' on interrupt 
  EIFR = bit(INTF0);                                // clear flag for interrupt 0
  interrupts();                                     //start interrups and 
  sleep_cpu();                                      //then immediately sleep
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}
