#include <avr/sleep.h>

#include <Wire.h>

unsigned long cycles=123456789;

#include "simpleds3231.h"
DS3231 rtc;

#include <OneWire.h>
#include <DallasTemperature.h>
OneWire oneWire(3);  //use pin 3
DallasTemperature sensors(&oneWire);
DeviceAddress TempA = { 0x28, 0xFF, 0x84, 0xA8, 0xC1, 0x16, 0x04, 0xF6 }; 

union ivar{ int intp; byte bytep[2]; };

void setup(){
  Serial.begin(9600);
  Wire.begin();
  pinMode(13, OUTPUT);
  pinMode(2, INPUT);
  pinMode(A3, OUTPUT);
  digitalWrite(A3, 0);
  if(rtc.lostPower()){
    Serial.println(F("RTC PWR LOST, SET.."));
    rtc.setTimeYear(2018); rtc.setTimeMonth(6); rtc.setTimeDay(3);
    rtc.setTimeHour(17); rtc.setTimeMinute(15); rtc.setTimeSecond(0);
    rtc.validateClock();
  }
  
  rtc.setAlarm1RMB(0b1110);  //ALARM 1 REGISTER MASK BITS - 1110 trips timer when seconds match. Still need to set other times to write this value into the clock 
  rtc.setAlarm1Day(3); rtc.setAlarm1Hour(13); rtc.setAlarm1Minute(13); rtc.setAlarm1Second(13);
  rtc.useAlarm1onINT();
  rtc.resetAlarm1(); //clears alarm flag
}

void loop(){
  //digitalWrite(A3, 0);
  delay(100);
  rtc.resetAlarm1(); //clears alarm flag
  cycles++;
  rtc.getTime();
  Serial.print(rtc.cyear());Serial.print('/');Serial.print(rtc.cmonth());Serial.print('/');Serial.print(rtc.cday());Serial.print(' ');Serial.print(rtc.chour());Serial.print(':');Serial.print(rtc.cminute());Serial.print(':');Serial.print(rtc.csecond());Serial.println();

  for(byte i=0; i<=0x12; i++){
  printDataHex(i);Serial.print(' ');printBin(rtc.read_register(i));
  }
  
  //delay(1000);
  /*
  sensors.begin();
  sensors.setResolution(TempA, 12);
  sensors.requestTemperatures();
  ivar tempAraw;
  tempAraw.intp = sensors.getTemp(TempA); //temperature in 128ths of degree C
  Serial.println(tempAraw.intp);
  printBin(tempAraw.bytep[1]); printBin(tempAraw.bytep[0]);
  Serial.println((float)tempAraw.intp/128,5);
  */
  blinklong(cycles);
  delay(1000);
  /*
  digitalWrite(A3, 1);
  //*******************GO TO SLEEP and enable interrupt*********************
  ADCSRA = 0; //disable ADCS
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts(); //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING); //goto 'wake' on interrupt 
  EIFR = bit(INTF0);  // clear flag for interrupt 0
  interrupts(); //start interrups and 
  sleep_cpu();  //then immediately sleep
  */
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}



void blinklong(long temp){
  for(byte i=0; i<=31; i++){
    if((1&(temp>>(31-i)))){
      digitalWrite(13,1);delay(2);digitalWrite(13,0);delay(3);
    }else{
      digitalWrite(13,1);delay(1);digitalWrite(13,0);delay(4);
    }
  }
  delay(10);
}

void printBin(byte temp){
  if(temp<0b10000000){Serial.print('0');}
  if(temp<0b1000000){Serial.print('0');}
  if(temp<0b100000){Serial.print('0');}
  if(temp<0b10000){Serial.print('0');}
  if(temp<0b1000){Serial.print('0');}
  if(temp<0b100){Serial.print('0');}
  if(temp<0b10){Serial.print('0');}
  Serial.println(temp,BIN); 
}

void printDataHex(byte temp){
  if(temp<0x10){  Serial.print('0');}
  Serial.print(temp, HEX); 
}
