#include <avr/power.h>
#include <avr/sleep.h>
#include <Wire.h>
#include <SPI.h>
#include <SPIMemory.h>
#include <simpleds3231.h>

#define powerBus 8 //pin for the power bus
                   //pin 2 is interrupt for clock to reactivate atmega
                   //pins 10-13 are spi pins for flash
                   //pins a4 a5 are i2c pins

SPIFlash flash;
DS3231 rtc;


struct frame_t{  //structure that stores each frame
  unsigned long cycle;      //4 bytes
  byte  cyear;
  byte  cmonth;
  byte  cday;
  byte  chour;
  byte  cminute;
  byte  csecond;
  float tempeReading; 
  float baromReading; 
  float humidReading;  
  float bvolt;               
};

frame_t frame;
unsigned long lastindex;
unsigned long index;
unsigned long icycle=0;

byte  keep_SPCR;
byte  keep_ADCSRA;


void setup() {
  pinMode(A5, INPUT); pinMode(A4, INPUT);
  pinMode(powerBus, OUTPUT); digitalWrite(powerBus, LOW); delay(500);
  Wire.begin();
  Serial.begin(9600);
  Serial.println(sizeof(frame));
  flash.begin(MB(4));
  Serial.println(F("TIME CAPSULE LONG DURATION ENVIROMENTAL LOGGER - Alan J. WIlson 2018"));
  lastindex=flash.getCapacity()/sizeof(frame)-1;
  Serial.print(F("Flash capacity: "));Serial.print(flash.getCapacity()); Serial.print(F(" bytes, "));Serial.print(lastindex+1); Serial.println(F(" frames"));
  Serial.print(F("Frame size: "));Serial.println(sizeof(frame));
  //Serial.println(F("Erasing Chip")); flash.eraseChip();
  
  Serial.print(F("Next ram index: "));//=========CALCULATE NEXT CHIP FREE SPACE=================
  while(1){
    if(!flash.readAnything(index*sizeof(frame), frame)){Serial.print(F("Read failed!"));}
    if(frame.cycle==4294967295){break;}
    index++;
  } Serial.println(index);

  
  Serial.println(F("Setting Clock"));
  rtc.setTimeYear(18); rtc.setTimeMonth(7); rtc.setTimeDay(4);
  rtc.setTimeHour(2); rtc.setTimeMinute(18); rtc.setTimeSecond(0);
  rtc.validateClock();


  dumpDS3231();
  printRTCTime();


  //dumpFlash();

  //ALARM 1 REGISTER MASK BITS - 1110 trips timer when seconds match. Still need to set other times to write this value into the clock 
  rtc.setAlarm1RMB(0b1110);  
  rtc.setAlarm1Day(5); rtc.setAlarm1Hour(11); rtc.setAlarm1Minute(0); rtc.setAlarm1Second(10);
  rtc.useAlarm1onINT();
  rtc.resetAlarm1(); //clears alarm flag

  
  /*for (unsigned long i = 0; i <= 100000 ; i++) {
    Serial.print(i);
    Serial.print(' ');
    if(flash.writeLong(i * 4, i)){Serial.println(F("OK"));}else{Serial.println(F("N"));}
  }*/

  keep_SPCR=SPCR; 
  keep_ADCSRA=ADCSRA;  
}

void loop() {
  //***************************************************POWER ON SECTION*******************************************************
  digitalWrite(powerBus, LOW); //turn on power bus
  DDRB  |=  ((1<<DDB5) | (1<<DDB3) | (1<<DDB2));   // set SCLK(D13), MOSI(D11) & SS(D10) as OUTPUT
  power_spi_enable();                              // enable the SPI clock 
  SPCR=keep_SPCR;                                  // enable SPI peripheral
  ADCSRA=keep_ADCSRA;                              // turn back ADCs
  delay(200); //Wire.begin(); delay(100);
  //***************************************************SENSOR READ SECTION***************************************************
  flash.begin(MB(4));
  rtc.resetAlarm1();                               //clear alarm flag
  Serial.println();
  Serial.print(F("Cycle "));Serial.println(icycle);
  Serial.print(F("Index "));Serial.println(index);
  
   

  
  frame.cycle=icycle;
  printRTCTime();

  
  if(flash.writeAnything(index*sizeof(frame), frame)){Serial.println(F("Write OK"));}else{Serial.println(F("Write FAILED"));}
  index++;
  icycle++; 
  //***************************************************POWER OFF SECTION******************************************************
  delay(200);
  //pinMode(A4, INPUT); pinMode(A5, INPUT);
  keep_SPCR=SPCR;                                              // save SPI state
  SPCR = 0;                                                    // disable SPI
  power_spi_disable();                                         // disable SPI clock
  DDRB  &= ~((1<<DDB5) | (1<<DDB4) | (1<<DDB3) | (1<<DDB2));   // set All SPI pins to INPUT
  PORTB &= ~((1<<DDB5) | (1<<DDB4) | (1<<DDB3) | (1<<DDB2));   // remove resistors
  digitalWrite(powerBus, HIGH);                                //turn off power bus
  //*********************************SLEEP*************************
  keep_ADCSRA=ADCSRA;
  ADCSRA = 0;                                       //disable ADCS
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts();                                   //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING);                //goto 'wake' on interrupt 
  EIFR = bit(INTF0);                                // clear flag for interrupt 0
  interrupts();                                     //start interrups and 
  sleep_cpu();                                      //then immediately sleep
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}
