void serialControl(){  //Serial command interface for debugging
  /*format: In Serial monitor, enter ASNNN.NNNNN
    where A is a letter (letter command),
          S is minus sign (Optional)
          NNN.NNN is a decimal number
    A      will become char verb
    SNNNN  will become float noun
  */
  char verb=0;
  float noun=0;
  char sbuffer[32];
  byte slen = 0;
  if(Serial.available()){
    for(byte i=0; i<=32; i++){sbuffer[i]=0;}
    while(slen <= 0){slen=Serial.readBytesUntil(13,sbuffer,32);}
    String sstr;
    for(byte i=0; i<=slen; i++){sstr+=sbuffer[i];}
    sstr.remove(0,1); //remove letter command
    verb = sbuffer[0];
    noun = sstr.toFloat();
  }
  Serial.flush();
  switch(verb){
    case 'e':
      serialmode=1;
      Serial.print(F("Serial mode running"));
      break;
    case 't':
      timedump=noun;
      break;
    case 'a':
      datadump=noun;
      if(datadump==1){Serial.println(); Serial.println(F("Index\tCycle\tYear\tMonth\tDay\tHour\tMinute\tSecond\tDS3231 Temperature (C)\tTemperature (C)\tPressure (Pa)\tHumidity (%)\tBattery (10-bit ADC)"));}
      break;
    case 'r':
       dumpDS3231();
      break;
    case 'y':
      rtc.setTimeYear(noun);
      printRTCTime();
      break;
    case 'm':
      rtc.setTimeMonth(noun);
      printRTCTime();
      break;
    case 'd':
      rtc.setTimeDay(noun);
      printRTCTime();
      break;
    case 'H':
      rtc.setTimeHour(noun);
      printRTCTime();
      break;
    case 'M':
      rtc.setTimeMinute(noun);
      printRTCTime();
      break;
    case 'S':
      rtc.setTimeSecond(noun);
      printRTCTime();
      break;
    case 'F':
      if(noun!=12345){
        Serial.println(F("Enter F12345 to erase flash"));
      }else{
        digitalWrite(redLed, HIGH);
        Serial.println(F("Erasing Chip")); flash.eraseChip(); Serial.println(F("Done."));
        digitalWrite(yellowLed, LOW);
      }
   }
   if(slen > 0){digitalWrite(yellowLed, HIGH); delay(200); digitalWrite(yellowLed, LOW);}
}
