void dumpFlash(){
  Serial.println();
  Serial.println(F("FLASH MEMORY DATA DUMP FOLLOWS")); 
  Serial.println(F("Index\tCycle\tYear\tMonth\tDay\tHour\tMinute\tSecond\tDS3231 Temperature (C)\tTemperature (C)\tPressure (Pa)\tHumidity (%)\tBattery (10-bit ADC)"));
  for(unsigned long t=0; t<lastindex; t++){
    if(!flash.readAnything(t*sizeof(frame), frame)){Serial.print(F("Read failed!"));}
    Serial.print(t); Serial.print('\t');
    Serial.print(frame.cycle); Serial.print('\t');
    Serial.print(frame.cyear); Serial.print('\t');
    Serial.print(frame.cmonth); Serial.print('\t');
    Serial.print(frame.cday); Serial.print('\t');
    Serial.print(frame.chour); Serial.print('\t');
    Serial.print(frame.cminute); Serial.print('\t');
    Serial.print(frame.csecond); Serial.print('\t');
    Serial.print(frame.ds3132temp); Serial.print('\t');
    
    Serial.print(frame.tempeReading); Serial.print('\t');
    Serial.print(frame.baromReading); Serial.print('\t');
    Serial.print(frame.humidReading); Serial.print('\t');
    Serial.print(frame.bvoltadc); Serial.print('\t');
    Serial.println();
    if(digitalRead(switch3)){return;}
  }
  
}

void printBin(byte temp){
  if(temp<0b10000000){Serial.print('0');}
  if(temp<0b1000000){Serial.print('0');}
  if(temp<0b100000){Serial.print('0');}
  if(temp<0b10000){Serial.print('0');}
  if(temp<0b1000){Serial.print('0');}
  if(temp<0b100){Serial.print('0');}
  if(temp<0b10){Serial.print('0');}
  Serial.print(temp,BIN); 
}
void printHex(byte temp){
  if(temp<0x10){  Serial.print('0');}
  Serial.print(temp, HEX); 
}

void dumpDS3231(){
  Serial.println();
  Serial.println(F("DS3231 registers:"));
  Serial.println(F("ADR DAT(BIN)"));
  for(byte j=0; j<=0x12; j++){
    printHex(j);Serial.print(' ');printBin(rtc.read_register(j));Serial.println();
  }
  Serial.println();
}

void printRTCTime(){
  rtc.getTime();
  frame.cyear=rtc.cyear();
  frame.cmonth=rtc.cmonth();
  frame.cday=rtc.cday();
  frame.chour=rtc.chour();
  frame.cminute=rtc.cminute();
  frame.csecond=rtc.csecond();
  Serial.print(F("Current time: "));
  if(rtc.cyear()<10){Serial.print('0');} Serial.print(rtc.cyear());
  Serial.print('/');
  if(rtc.cmonth()<10){Serial.print('0');} Serial.print(rtc.cmonth());
  Serial.print('/');
  if(rtc.cday()<10){Serial.print('0');} Serial.print(rtc.cday());
  Serial.print(' ');
  if(rtc.chour()<10){Serial.print('0');} Serial.print(rtc.chour());
  Serial.print(':');
  if(rtc.cminute()<10){Serial.print('0');} Serial.print(rtc.cminute());
  Serial.print(':');
  if(rtc.csecond()<10){Serial.print('0');} Serial.println(rtc.csecond());
}

byte getButtonPresses(){
  byte presses=255;
  digitalWrite(yellowLed, HIGH);
  while(!digitalRead(button)){delay(10);} //wait for button to not be pressed
  delay(50);
  unsigned long timeoutTime=millis()+10000000L;
  while(timeoutTime>=millis()){
    if(!digitalRead(button)){
      digitalWrite(yellowLed, LOW);
      digitalWrite(redLed, HIGH);
      timeoutTime=millis()+2000; //reset timer
      presses++;
      Serial.println(presses);
      while(!digitalRead(button)){delay(10);}
      delay(50);
      digitalWrite(redLed, LOW);
      digitalWrite(yellowLed, HIGH);
    }
  }
  digitalWrite(yellowLed, LOW);
  digitalWrite(greenLed, HIGH);
  Serial.print(F("Confirmed: ")); Serial.println(presses); Serial.println();
  delay(700);
  digitalWrite(greenLed, LOW);
  return presses;
}

void setClockProcedure(){
    Serial.println(F("SET CLOCK PROCEDURE - Press button n number of times for each value and wait 2s when done."));
    Serial.println(F("Enter RTC year (2 digit)"));    byte ckA = getButtonPresses(); 
    Serial.println(F("Enter RTC month"));             byte ckB = getButtonPresses(); 
    Serial.println(F("Enter RTC day of month"));      byte ckC = getButtonPresses(); 
    Serial.println(F("Enter RTC hour (24h format)")); byte ckD = getButtonPresses(); 
    Serial.println(F("Enter RTC minute"));            byte ckE = getButtonPresses(); 
    Serial.println(F("Enter RTCsecond "));            byte ckF = getButtonPresses(); 
    Serial.println(F("Press button to set clock"));
    digitalWrite(yellowLed, HIGH);
    while(digitalRead(button)){} //wait for a button press
    rtc.setTimeYear(ckA);
    rtc.setTimeMonth(ckB);
    rtc.setTimeDay(ckC);
    rtc.setTimeHour(ckD);
    rtc.setTimeMinute(ckE);
    rtc.setTimeSecond(ckF);
    rtc.resetAlarm1(); rtc.validateClock();
    Serial.println(F("Done setting clock."));
    digitalWrite(yellowLed, LOW);
    while(!digitalRead(button)){delay(10);} //wait for button to not be pressed
    delay(1000);
}

