//Time Capsule enviroment logger - Alan J. Wilson 2018
//Designed to run on batteries, and store sensor values every hour for a total of 5 years

//pin 2 is interrupt for clock to reactivate atmega
//pins 10-13 are spi pins for flash
//pins a4 a5 are i2c pins for ds3231 clock and bme280 pressure, humidity, temperature sensor
                   
#include <avr/power.h>
#include <avr/sleep.h>
#include <Wire.h>
#include <SPI.h>
#include <SPIMemory.h>
#include <simpleds3231.h>
#include "SparkFunBME280.h"

SPIFlash flash;
DS3231 rtc;
BME280 tphSensor;

struct frame_t{  //structure that stores each frame
  unsigned long cycle;      //4 bytes
  byte  cyear;
  byte  cmonth;
  byte  cday;
  byte  chour;
  byte  cminute;
  byte  csecond;
  float tempeReading; 
  float baromReading; 
  float humidReading;
  float ds3132temp; 
  unsigned int bvoltadc;              
  float spare; 
};

frame_t frame;

unsigned long lastindex; //limit for frame
unsigned long index;     //current index to store
unsigned long icycle=0;  //current cycle (since atmega has been powered on)
byte  keep_ADCSRA;       //stores adc state;

void setup() {
  pinMode(8, INPUT_PULLUP);
  pinMode(2, INPUT);
  pinMode(A3, INPUT);
  pinMode(6, OUTPUT); digitalWrite(6, HIGH);
  Serial.begin(115200);
  Wire.begin();
  SPI.begin(); SPI.beginTransaction(SPISettings(100000L,MSBFIRST,SPI_MODE0)); //start spi and set spi clock speed
  delay(10); pinMode(10, OUTPUT); digitalWrite(10, LOW); SPI.transfer(0xAB); digitalWrite(10, HIGH); delay(10); //power up flash chip
  flash.begin(MB(4)); //start flash
  
  //Serial.println(F("Setting Clock")); rtc.resetAlarm1(); rtc.setTimeYear(18); rtc.setTimeMonth(8); rtc.setTimeDay(12); rtc.setTimeHour(18); rtc.setTimeMinute(31); rtc.setTimeSecond(0); rtc.validateClock(); Serial.println(F("OK")); while(1){}
  
  Serial.println(F("TIME CAPSULE LONG DURATION ENVIROMENTAL LOGGER - Alan J. WIlson 2018"));
  printRTCTime();
  lastindex=flash.getCapacity()/32-1;
  Serial.print(F("Flash capacity: "));Serial.print(flash.getCapacity()); Serial.print(F(" bytes, "));Serial.print(lastindex+1); Serial.println(F(" frames"));
  Serial.print(F("Frame size: "));Serial.println(sizeof(frame));
  if(sizeof(frame)>32){Serial.println(F("Frame size too large!")); while(1){}}
  //Serial.println(F("Erasing Chip")); flash.eraseChip(); Serial.println(F("Done.")); while(1){}
  Serial.print(F("Next ram index: "));//=========CALCULATE NEXT CHIP FREE SPACE=================
  while(1){
    if(!flash.readAnything(index*32, frame)){Serial.println(F("Read failed!")); break;}
    if(frame.cycle==4294967295){break;}
    index++;
  } Serial.println(index);
 
  tphSensor.settings.commInterface = I2C_MODE;
  tphSensor.settings.I2CAddress = 0x76;
  tphSensor.settings.runMode = 0; //3 for normal mode (ON), 0 for sleep mode (OFF)
  tphSensor.settings.tStandby = 0;
  tphSensor.settings.filter = 0;
  tphSensor.settings.tempOverSample = 1;
  tphSensor.settings.pressOverSample = 1;
  tphSensor.settings.humidOverSample = 1;
  delay(10);
  tphSensor.begin();

  //dumpFlash();

  //ALARM 1 REGISTER MASK BITS - 1110 trips timer when seconds match. Still need to set other times to write this value into the clock 
  rtc.setAlarm1RMB(0b1110);  
  rtc.setAlarm1Day(5); rtc.setAlarm1Hour(11); rtc.setAlarm1Minute(0); rtc.setAlarm1Second(10);
  rtc.useAlarm1onINT();
  rtc.resetAlarm1(); //clears alarm flag

  dumpDS3231();
  
  keep_ADCSRA=ADCSRA;  
}

void loop(){
  digitalWrite(6, HIGH);
  //***************************************************POWER ON SECTION*******************************************************
  ADCSRA=keep_ADCSRA;    // turn back ADCs

  
  //***************************************************SENSOR READ SECTION***************************************************
  Serial.println();
  rtc.resetAlarm1();                               //clear alarm flag
  frame.ds3132temp=rtc.getTemp();
  frame.cycle=icycle;
  printRTCTime();

  frame.bvoltadc=analogRead(A3);
  
  Serial.print(F("Cycle: "));Serial.println(icycle);
  Serial.print(F("Index: "));Serial.println(index);
  Serial.print(F("Battery ADC: "));Serial.println(frame.bvoltadc);
  Serial.print(F("DS3231 Temperature (C): "));Serial.println(frame.ds3132temp);

  tphSensor.settings.runMode = 3; delay(10); tphSensor.begin();
  frame.tempeReading = tphSensor.readTempC();
  frame.baromReading = tphSensor.readFloatPressure();
  frame.humidReading = tphSensor.readFloatHumidity();
  Serial.print(F("BME280 Temperature (C): "));Serial.println(frame.tempeReading);
  Serial.print(F("BME280 Pressure   (Pa): "));Serial.println(frame.baromReading);
  Serial.print(F("BME280 Humidity    (%): "));Serial.println(frame.humidReading);
  tphSensor.settings.runMode = 0; delay(10); tphSensor.begin();

  flash.powerUp(); delay(1);
  if(digitalRead(8)==LOW){dumpFlash();}
  byte retry=10;
  while(retry>0){
    retry--;
    if(flash.writeAnything(index*32, frame)){Serial.println(F("Write OK")); break;}else{Serial.println(F("Write FAILED"));}
    delay(100);
  }
  flash.powerDown();
  
  index++;
  icycle++; 
  
  delay(50);
  digitalWrite(6, LOW);
  //***************************************************POWER OFF SECTION******************************************************
  keep_ADCSRA=ADCSRA;
  ADCSRA = 0;                                       //disable ADCS
  
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts();                                   //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING);                //goto 'wake' on interrupt 
  EIFR = bit(INTF0);                                // clear flag for interrupt 0
  interrupts();                                     //start interrups and 
  sleep_cpu();                                      //then immediately sleep
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}
