//Time Capsule enviroment logger - Alan J. Wilson 2018
//Designed to run on batteries, and store sensor values every hour for a total of 5 years

//pin 2 is interrupt for clock to reactivate atmega
//pins 10-13 are spi pins for flash
//pins a4 a5 are i2c pins for ds3231 clock and bme280 pressure, humidity, temperature sensor
                   
#include <avr/power.h>
#include <avr/sleep.h>
#include <Wire.h>
#include <SPI.h>
#include <SPIMemory.h>
#include <simpleds3231.h>
#include "SparkFunBME280.h"

#define greenLed A0
#define redLed A1
#define yellowLed A2
#define button 3      //dip switch on 4 - 7  

SPIFlash flash;
DS3231 rtc;
BME280 tphSensor;

struct frame_t{  //structure that stores each frame
  unsigned long cycle;      //4 bytes
  byte  cyear;
  byte  cmonth;
  byte  cday;
  byte  chour;
  byte  cminute;
  byte  csecond;
  float tempeReading; 
  float baromReading; 
  float humidReading;
  float ds3132temp; 
  unsigned int bvoltadc;              
  float spare; 
};

frame_t frame;

unsigned long lastindex; //limit for frame
unsigned long index;     //current index to store
unsigned long icycle=0;  //current cycle (since atmega has been powered on)
byte  keep_ADCSRA;       //stores adc state;

void setup() {
  pinMode(button, INPUT_PULLUP);
  pinMode(4, INPUT_PULLUP); pinMode(5, INPUT_PULLUP); pinMode(6, INPUT_PULLUP); pinMode(7, INPUT_PULLUP);
  pinMode(greenLed, OUTPUT); pinMode(redLed, OUTPUT); pinMode(yellowLed, OUTPUT);
  Serial.begin(115200);
  Serial.println(F("TIME CAPSULE LONG DURATION ENVIROMENTAL LOGGER - Alan J. WIlson 2018"));
  Wire.begin();
  SPI.begin(); SPI.beginTransaction(SPISettings(100000L,MSBFIRST,SPI_MODE0)); //start spi and set spi clock speed
  delay(10); pinMode(10, OUTPUT); digitalWrite(10, LOW); SPI.transfer(0xAB); digitalWrite(10, HIGH); delay(10); //power up flash chip with raw command (in case is sleeping)
  flash.begin(MB(4)); //start flash
  
  digitalWrite(yellowLed, HIGH); delay(200); digitalWrite(greenLed, HIGH); delay(200); digitalWrite(redLed, HIGH); delay(200); digitalWrite(redLed, LOW); digitalWrite(greenLed, LOW); digitalWrite(yellowLed, LOW); //3 led test pattern

  while(1){
    Serial.println(F("SET CLOCK PROCEDURE - Press button n number of times for each value and wait 2s when done."));
    Serial.println(F("Enter RTC year (2 digit)"));    rtc.setTimeYear(getButtonPresses()); 
    Serial.println(F("Enter RTC month"));             rtc.setTimeMonth(getButtonPresses());
    Serial.println(F("Enter RTC day of month"));      rtc.setTimeDay(getButtonPresses());
    Serial.println(F("Enter RTC hour (24h format)")); rtc.setTimeHour(getButtonPresses());
    Serial.println(F("Enter RTC minute"));            rtc.setTimeMinute(getButtonPresses());
    Serial.println(F("Enter RTCsecond "));            rtc.setTimeSecond(getButtonPresses());
    Serial.println(F("Press button to set clock"));
    digitalWrite(yellowLed, HIGH);
    while(digitalRead(button)){} //wait for a button press
    
    rtc.resetAlarm1(); rtc.validateClock();
    Serial.println(F("Done setting clock."));
    digitalWrite(yellowLed, LOW);
    while(!digitalRead(button)){delay(10);} //wait for button to not be pressed
    delay(1000);
  }

  
  if(bitRead(dipswitches(),0)==1){Serial.println(F("Setting Clock, press button to set")); while(digitalRead(button)){} rtc.resetAlarm1(); rtc.setTimeYear(18); rtc.setTimeMonth(8); rtc.setTimeDay(27); rtc.setTimeHour(0); rtc.setTimeMinute(14); rtc.setTimeSecond(0); rtc.validateClock(); Serial.println(F("OK")); digitalWrite(greenLed, HIGH); delay(3000);}
 
  printRTCTime();
  lastindex=flash.getCapacity()/32-1;
  Serial.print(F("Flash capacity: "));Serial.print(flash.getCapacity()); Serial.print(F(" bytes, "));Serial.print(lastindex+1); Serial.println(F(" frames"));
  Serial.print(F("Frame size: "));Serial.println(sizeof(frame));
  if(sizeof(frame)>32){Serial.println(F("Frame size too large!")); while(1){}}
  if(bitRead(dipswitches(),1)==1){delay(1000);digitalWrite(yellowLed, HIGH); Serial.println(F("Press button to erase flash")); while(digitalRead(button)){} digitalWrite(redLed, HIGH); Serial.println(F("Erasing Chip")); flash.eraseChip(); Serial.println(F("Done.")); digitalWrite(yellowLed, LOW);}
  Serial.print(F("Next ram index: "));//=========CALCULATE NEXT CHIP FREE SPACE=================
  while(1){
    if(!flash.readAnything(index*32, frame)){Serial.println(F("Read failed!")); break;}
    if(frame.cycle==4294967295){break;}
    index++;
  } Serial.println(index);

  //SETUP OF THE BME280 SENSOR
  tphSensor.settings.commInterface = I2C_MODE;
  tphSensor.settings.I2CAddress = 0x76;
  tphSensor.settings.runMode = 0; //3 for normal mode (ON), 0 for sleep mode (OFF)
  tphSensor.settings.tStandby = 0;
  tphSensor.settings.filter = 0;
  tphSensor.settings.tempOverSample = 1;
  tphSensor.settings.pressOverSample = 1;
  tphSensor.settings.humidOverSample = 1;
  delay(10);
  tphSensor.begin();

  //ALARM 1 REGISTER MASK BITS - 1110 trips timer when seconds match. Still need to set other times to write this value into the clock 
  rtc.setAlarm1RMB(0b1110);  
  rtc.setAlarm1Day(5); rtc.setAlarm1Hour(11); rtc.setAlarm1Minute(0); rtc.setAlarm1Second(10);
  rtc.useAlarm1onINT();
  rtc.resetAlarm1(); //clears alarm flag

  //dumpDS3231(); //dumps the ds3231 registers for debugging purposes.
  keep_ADCSRA=ADCSRA;
}

void loop(){
  digitalWrite(greenLed, HIGH);
  if(bitRead(dipswitches(),3)==1){flash.powerUp(); delay(1); dumpFlash(); delay(1); flash.powerDown();}
  //***************************************************POWER ON SECTION*******************************************************
  ADCSRA=keep_ADCSRA;    // turn back ADCs

  
  //***************************************************SENSOR READ SECTION***************************************************
  Serial.println();
  rtc.resetAlarm1();                               //clear alarm flag
  frame.ds3132temp=rtc.getTemp();
  frame.cycle=icycle;
  printRTCTime();

  frame.bvoltadc=0; //=analogRead(batteryADC);
  
  Serial.print(F("Cycle: "));Serial.println(icycle);
  Serial.print(F("Index: "));Serial.println(index);
  Serial.print(F("Battery ADC: "));Serial.println(frame.bvoltadc);
  Serial.print(F("DS3231 Temperature (C): "));Serial.println(frame.ds3132temp);

  tphSensor.settings.runMode = 3; delay(10); tphSensor.begin();
  frame.tempeReading = tphSensor.readTempC();
  frame.baromReading = tphSensor.readFloatPressure();
  frame.humidReading = tphSensor.readFloatHumidity();
  Serial.print(F("BME280 Temperature (C): "));Serial.println(frame.tempeReading);
  Serial.print(F("BME280 Pressure   (Pa): "));Serial.println(frame.baromReading);
  Serial.print(F("BME280 Humidity    (%): "));Serial.println(frame.humidReading);
  tphSensor.settings.runMode = 0; delay(10); tphSensor.begin();

  flash.powerUp(); delay(1);
  //if(digitalRead(8)==LOW){dumpFlash();}
  byte retry=10;
  while(retry>0){
    retry--;
    if(flash.writeAnything(index*32, frame)){Serial.println(F("Write OK")); break;}else{Serial.println(F("Write FAILED"));}
    delay(100);
  }
  flash.powerDown();
  
  index++;
  icycle++; 
  
  delay(50);
  digitalWrite(redLed, LOW); digitalWrite(greenLed, LOW); digitalWrite(yellowLed, LOW);
  //***************************************************POWER OFF SECTION******************************************************
  keep_ADCSRA=ADCSRA;
  ADCSRA = 0;                                       //disable ADCS
  
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts();                                   //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING);                //goto 'wake' on interrupt (using clock alarm)
  attachInterrupt(1, wake, FALLING);                //goto 'wake' on interrupt (using button) 
  EIFR = bit(INTF0);                                // clear flag for interrupt 0
  interrupts();                                     //start interrups and 
  sleep_cpu();                                      //then immediately sleep
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}
