void dumpFlash(){
  Serial.println();
  Serial.println(F("FLASH MEMORY DATA DUMP FOLLOWS")); 
  Serial.println(F("Index\tCycle\tYear\tMonth\tDay\tHour\tMinute\tSecond\tDS3231 Temperature (C)\tTemperature (C)\tPressure (Pa)\tHumidity (%)\tBattery (10-bit ADC)"));
  for(unsigned long t=0; t<lastindex; t++){
    if(!flash.readAnything(t*sizeof(frame), frame)){Serial.print(F("Read failed!"));}
    Serial.print(t); Serial.print('\t');
    Serial.print(frame.cycle); Serial.print('\t');
    Serial.print(frame.cyear); Serial.print('\t');
    Serial.print(frame.cmonth); Serial.print('\t');
    Serial.print(frame.cday); Serial.print('\t');
    Serial.print(frame.chour); Serial.print('\t');
    Serial.print(frame.cminute); Serial.print('\t');
    Serial.print(frame.csecond); Serial.print('\t');
    Serial.print(frame.ds3132temp); Serial.print('\t');
    
    Serial.print(frame.tempeReading); Serial.print('\t');
    Serial.print(frame.baromReading); Serial.print('\t');
    Serial.print(frame.humidReading); Serial.print('\t');
    Serial.print(frame.bvoltadc); Serial.print('\t');
    Serial.println();
    if(digitalRead(8)==HIGH){return;}
  }
  
}

void printBin(byte temp){
  if(temp<0b10000000){Serial.print('0');}
  if(temp<0b1000000){Serial.print('0');}
  if(temp<0b100000){Serial.print('0');}
  if(temp<0b10000){Serial.print('0');}
  if(temp<0b1000){Serial.print('0');}
  if(temp<0b100){Serial.print('0');}
  if(temp<0b10){Serial.print('0');}
  Serial.print(temp,BIN); 
}
void printHex(byte temp){
  if(temp<0x10){  Serial.print('0');}
  Serial.print(temp, HEX); 
}

void dumpDS3231(){
  Serial.println();
  Serial.println(F("DS3231 registers:"));
  Serial.println(F("ADR DAT(BIN)"));
  for(byte j=0; j<=0x12; j++){
    printHex(j);Serial.print(' ');printBin(rtc.read_register(j));Serial.println();
  }
  Serial.println();
}

void printRTCTime(){
  rtc.getTime();
  frame.cyear=rtc.cyear();
  frame.cmonth=rtc.cmonth();
  frame.cday=rtc.cday();
  frame.chour=rtc.chour();
  frame.cminute=rtc.cminute();
  frame.csecond=rtc.csecond();
  Serial.print(F("Current time: "));
  if(rtc.cyear()<10){Serial.print('0');} Serial.print(rtc.cyear());
  Serial.print('/');
  if(rtc.cmonth()<10){Serial.print('0');} Serial.print(rtc.cmonth());
  Serial.print('/');
  if(rtc.cday()<10){Serial.print('0');} Serial.print(rtc.cday());
  Serial.print(' ');
  if(rtc.chour()<10){Serial.print('0');} Serial.print(rtc.chour());
  Serial.print(':');
  if(rtc.cminute()<10){Serial.print('0');} Serial.print(rtc.cminute());
  Serial.print(':');
  if(rtc.csecond()<10){Serial.print('0');} Serial.println(rtc.csecond());
}
