

void writeEEPROM(long eeAddress, byte data)
{
  if (eeAddress < 65536)
  {
    Wire.beginTransmission(0x50);
    eeAddress &= 0xFFFF; //Erase the first 16 bits of the long variable
  }
  else
  {
    Wire.beginTransmission(0x54);
  }

  Wire.write((int)(eeAddress >> 8)); // MSB
  Wire.write((int)(eeAddress & 0xFF)); // LSB
  Wire.write(data);
  Wire.endTransmission();
}

byte readEEPROM(long eeaddress)
{
  if (eeaddress < 65536)
    Wire.beginTransmission(0x50);
  else
    Wire.beginTransmission(0x54);

  Wire.write((int)(eeaddress >> 8)); // MSB
  Wire.write((int)(eeaddress & 0xFF)); // LSB
  Wire.endTransmission();

  if (eeaddress < 65536)
    Wire.requestFrom(0x50, 1);
  else
    Wire.requestFrom(0x54, 1);

  byte rdata = 0xFF;
  if (Wire.available()) rdata = Wire.read();
  return rdata;
}

void writeIntEEPROM(long eeaddress, int temp){
  ivar conv;
  conv.intp = temp;
  writeEEPROM(eeaddress*2,  conv.bytep[1]);
  delay(8);
  writeEEPROM(eeaddress*2+1,conv.bytep[0]);
  delay(8);
}

int readIntEEPROM(long eeaddress){
  ivar conv;
  conv.bytep[1]=readEEPROM(eeaddress*2);
  delay(8);
  conv.bytep[0]=readEEPROM(eeaddress*2+1);
  delay(8);
  return conv.intp;
}
