#include <avr/sleep.h>

#include <Wire.h>

long cycles=0;

#include "simpleds3231.h"
DS3231 rtc;

#include <OneWire.h>
#include <DallasTemperature.h>
OneWire oneWire(3);  //use pin 3
DallasTemperature sensors(&oneWire);
DeviceAddress TempA = { 0x28, 0xFF, 0x84, 0xA8, 0xC1, 0x16, 0x04, 0xF6 }; 

union ivar{ int intp; byte bytep[2]; };

void setup(){
  Serial.begin(9600);
  Wire.begin();
  pinMode(13, OUTPUT);
  pinMode(2, INPUT);
  pinMode(A3, OUTPUT);
  digitalWrite(A3, 0); delay(50);
  if(rtc.lostPower()){
    Serial.println(F("RTC PWR LOST, SET.."));
    rtc.setTimeYear(2018); rtc.setTimeMonth(6); rtc.setTimeDay(6);
    rtc.setTimeHour(00); rtc.setTimeMinute(10); rtc.setTimeSecond(0);
    rtc.validateClock();
  }
  
  rtc.setAlarm1RMB(0b1110);  //ALARM 1 REGISTER MASK BITS - 1110 trips timer when seconds match. Still need to set other times to write this value into the clock 
  rtc.setAlarm1Day(5); rtc.setAlarm1Hour(11); rtc.setAlarm1Minute(0); rtc.setAlarm1Second(10);
  rtc.useAlarm1onINT();
  rtc.resetAlarm1(); //clears alarm flag

  Serial.println(F("sample,unixtime/3600,temperature(degC/128),temperature(degC)"));
  for(long y=0; y<=65535; y++){
    Serial.print(y);Serial.print(',');
    Serial.print(readIntEEPROM(y));Serial.print(',');
    Serial.print((float)readIntEEPROM(y)/128, 7);Serial.println();  
  }
  
  
}

void loop(){
  digitalWrite(A3, 0); delay(50);
  rtc.resetAlarm1(); //clear alarm flag
  rtc.getTime();
  Serial.print(F("Cycle: ")); Serial.println(cycles);
  Serial.print(F("RTC: "));Serial.print(rtc.cyear());Serial.print('/');Serial.print(rtc.cmonth());Serial.print('/');Serial.print(rtc.cday());Serial.print(' ');Serial.print(rtc.chour());Serial.print(':');Serial.print(rtc.cminute());Serial.print(':');Serial.print(rtc.csecond());Serial.println();
  //printBin(rtc.read_register(0x0e));
  //printBin(rtc.read_register(0x0f));
  sensors.begin();
  sensors.setResolution(TempA, 12);
  sensors.requestTemperatures();
  ivar tempAraw;
  tempAraw.intp = sensors.getTemp(TempA); //temperature in 128ths of degree C
  Serial.print(F("tempraw: ")); Serial.println(tempAraw.intp);
  printBin(tempAraw.bytep[1]); printBin(tempAraw.bytep[0]);
  Serial.print(F("temp c: ")); Serial.println((float)tempAraw.intp/128,5);

  

  

  blinklong(cycles);
  delay(50); digitalWrite(A3, 1);
  cycles++;

  delay(1000);
  /*
  //*******************GO TO SLEEP and enable interrupt*********************
  ADCSRA = 0; //disable ADCS
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts(); //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING); //goto 'wake' on interrupt 
  EIFR = bit(INTF0);  // clear flag for interrupt 0
  interrupts(); //start interrups and 
  sleep_cpu();  //then immediately sleep
  */
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}
