

void writeEEPROM(long eeAddress, byte data)
{
  if (eeAddress < 65536)
  {
    Wire.beginTransmission(0x50);
    eeAddress &= 0xFFFF; //Erase the first 16 bits of the long variable
  }
  else
  {
    Wire.beginTransmission(0x54);
  }

  Wire.write((int)(eeAddress >> 8)); // MSB
  Wire.write((int)(eeAddress & 0xFF)); // LSB
  Wire.write(data);
  Wire.endTransmission();
}

byte readEEPROM(long eeaddress)
{
  if (eeaddress < 65536)
    Wire.beginTransmission(0x50);
  else
    Wire.beginTransmission(0x54);

  Wire.write((int)(eeaddress >> 8)); // MSB
  Wire.write((int)(eeaddress & 0xFF)); // LSB
  Wire.endTransmission();

  if (eeaddress < 65536)
    Wire.requestFrom(0x50, 1);
  else
    Wire.requestFrom(0x54, 1);

  byte rdata = 0xFF;
  if (Wire.available()) rdata = Wire.read();
  return rdata;
}

void writeIntEEPROM(long eeaddress, int temp){
  ivar conv;
  conv.intp = temp;
  writeEEPROM(eeaddress*2,  conv.bytep[1]);
  delay(8);
  writeEEPROM(eeaddress*2+1,conv.bytep[0]);
  delay(8);
}

int readIntEEPROM(long eeaddress){
  ivar conv;
  conv.bytep[1]=readEEPROM(eeaddress*2);
  delay(8);
  conv.bytep[0]=readEEPROM(eeaddress*2+1);
  delay(8);
  return conv.intp;
}

void printBin(byte temp){
  if(temp<0b10000000){Serial.print('0');}
  if(temp<0b1000000){Serial.print('0');}
  if(temp<0b100000){Serial.print('0');}
  if(temp<0b10000){Serial.print('0');}
  if(temp<0b1000){Serial.print('0');}
  if(temp<0b100){Serial.print('0');}
  if(temp<0b10){Serial.print('0');}
  Serial.print(temp,BIN); 
}
void printHex(byte temp){
  if(temp<0x10){  Serial.print('0');}
  Serial.print(temp, HEX); 
}

void dumpDS3231(){
  Serial.println(F("DS3231 registers:"));
  Serial.println(F("ADR DAT(BIN)"));
  for(byte j=0; j<=0x12; j++){
    printHex(j);Serial.print(' ');printBin(rtc.read_register(j));Serial.println();
  }
  Serial.println();
}

void printRTCTime(){
  rtc.getTime();
  Serial.print(F("Current time (UTC): "));
  Serial.print(rtc.cyear());
  Serial.print('/');
  if(rtc.cmonth()<10){Serial.print('0');} Serial.print(rtc.cmonth());
  Serial.print('/');
  if(rtc.cday()<10){Serial.print('0');} Serial.print(rtc.cday());
  Serial.print(' ');
  if(rtc.chour()<10){Serial.print('0');} Serial.print(rtc.chour());
  Serial.print(':');
  if(rtc.cminute()<10){Serial.print('0');} Serial.print(rtc.cminute());
  Serial.print(':');
  if(rtc.csecond()<10){Serial.print('0');} Serial.print(rtc.csecond());
  Serial.print(' ');
  Serial.println(h2000_now());
}

void eraseEEPROM(){
  Serial.println(F("Erasing EEPROM"));
  for(long y=0; y<=65535; y++){
    writeIntEEPROM(y,0xffff);
    if(y%655==0){Serial.print(y/655);Serial.println('%');}
  }
  Serial.println(F("Done."));
}

void dumpTable(){
  Serial.println(F("sample,unixtime/3600,temperature(degC/128),temperature(degC)"));
  for(long y=0; y<=65535; y++){
    Serial.print(y);Serial.print(',');
    Serial.print(y+Start_H_Hour);Serial.print(',');
    Serial.print(readIntEEPROM(y));Serial.print(',');
    Serial.print((float)readIntEEPROM(y)/128, 7);Serial.println();  
  }
}

//EXTRA TIME FUNCTIONS*********************************************
const uint8_t daysInMonth [] PROGMEM = { 31,28,31,30,31,30,31,31,30,31,30,31 };

long h2000(int y, byte m, byte d, byte h, byte n) { //hours from given date to 2000
    if (y >= 2000)
        y -= 2000;
    long temp = d; //start with days
    for(uint8_t i = 1; i < m; ++i){temp += pgm_read_byte(daysInMonth + i - 1);}
    if (m > 2 && y % 4 == 0){temp++;}
    temp+= + 365 * y + (y + 3) / 4 - 1;
    temp=temp*24+h;
    temp=temp*60+n; //minutes
    return temp;
}

long h2000_now(){
  return h2000(rtc.cyear(),rtc.cmonth(),rtc.cday(),rtc.chour(),rtc.cminute());
}
