#include <avr/sleep.h>

#include <Wire.h>

long cycles=0;

#include "simpleds3231.h"
DS3231 rtc;

union ivar{ int intp; byte bytep[2]; };

long Start_H_Hour=0;

void setup(){
  Serial.begin(9600);
  pinMode(A3, OUTPUT); digitalWrite(A3, LOW); delay(100);
  Wire.begin();
  pinMode(13, OUTPUT);
  pinMode(2, INPUT);
  digitalWrite(A3, 0); delay(50);
  Serial.println(F("LONG DURATION TEMPERATURE LOGGER - Alan J. WIlson 2018"));
  Start_H_Hour = h2000(2018, 6, 7, 2, 6); //December 27, 2018, at midnight

  //for(long t=0;t<=65535;t++){
    //Serial.println(((float)readIntEEPROM(t)/128)*1.8+32);
  //}
  
  if(rtc.lostPower()){
    Serial.println(F("RTC PWR LOST, SET.."));
    rtc.setTimeYear(2018); rtc.setTimeMonth(6); rtc.setTimeDay(18);
    rtc.setTimeHour(2); rtc.setTimeMinute(18); rtc.setTimeSecond(30);
    rtc.validateClock();
  }
  
  rtc.setAlarm1RMB(0b1110);  //ALARM 1 REGISTER MASK BITS - 1110 trips timer when seconds match. Still need to set other times to write this value into the clock 
  rtc.setAlarm1Day(5); rtc.setAlarm1Hour(11); rtc.setAlarm1Minute(0); rtc.setAlarm1Second(10);
  rtc.useAlarm1onINT();
  rtc.resetAlarm1(); //clears alarm flag

  dumpDS3231();

  Serial.print(F("Starting time index: ")); Serial.println(Start_H_Hour);
  printRTCTime();

  //while(1){ printRTCTime(); delay(250); }
}

void loop(){
  digitalWrite(13, LOW);
  digitalWrite(A3, 0); delay(100); Serial.println(); //turn on full power
  Wire.begin();
  rtc.resetAlarm1(); //clear alarm flag
    
  Serial.print(F("Cycle: ")); Serial.println(cycles);
  printRTCTime(); //time updates here


  delay(100); digitalWrite(A3, 1); //turn off full power
  cycles++;

  digitalWrite(13, HIGH);
  pinMode(A5, INPUT); pinMode(A4, INPUT);
  //*******************GO TO SLEEP and enable interrupt*********************
  ADCSRA = 0; //disable ADCS
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts(); //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING); //goto 'wake' on interrupt 
  EIFR = bit(INTF0);  // clear flag for interrupt 0
  interrupts(); //start interrups and 
  sleep_cpu();  //then immediately sleep
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}
