#include <avr/sleep.h>

#include <Wire.h>

long cycles=0;

#include "simpleds3231.h"
DS3231 rtc;

#include <OneWire.h>
#include <DallasTemperature.h>
OneWire oneWire(3);  //use pin 3
DallasTemperature sensors(&oneWire);
DeviceAddress TempA = { 0x28, 0xFF, 0x84, 0xA8, 0xC1, 0x16, 0x04, 0xF6 }; 

union ivar{ int intp; byte bytep[2]; };

long Start_H_Hour=0;

void setup(){
  Serial.begin(9600);
  Wire.begin();
  pinMode(13, OUTPUT);
  pinMode(2, INPUT);
  pinMode(A3, OUTPUT);
  digitalWrite(A3, 0); delay(50);
  Serial.println(F("LONG DURATION TEMPERATURE LOGGER - Alan J. WIlson 2018"));
  Start_H_Hour = h2000(2018, 4, 5, 0); //December 27, 2018, at midnight
  
  if(rtc.lostPower()){
    Serial.println(F("RTC PWR LOST, SET.."));
    rtc.setTimeYear(2018); rtc.setTimeMonth(6); rtc.setTimeDay(6);
    rtc.setTimeHour(1); rtc.setTimeMinute(8); rtc.setTimeSecond(0);
    rtc.validateClock();
  }
  
  rtc.setAlarm1RMB(0b1110);  //ALARM 1 REGISTER MASK BITS - 1110 trips timer when seconds match. Still need to set other times to write this value into the clock 
  rtc.setAlarm1Day(5); rtc.setAlarm1Hour(11); rtc.setAlarm1Minute(0); rtc.setAlarm1Second(10);
  rtc.useAlarm1onINT();
  rtc.resetAlarm1(); //clears alarm flag

  dumpDS3231();

  Serial.print(F("Starting time index: ")); Serial.println(Start_H_Hour);
  printRTCTime();

  /*
  Serial.println(F("sample,unixtime/3600,temperature(degC/128),temperature(degC)"));
  for(long y=0; y<=65535; y++){
    Serial.print(y);Serial.print(',');
    Serial.print(readIntEEPROM(y));Serial.print(',');
    Serial.print((float)readIntEEPROM(y)/128, 7);Serial.println();  
  }
  */
  
  
}

void loop(){
  digitalWrite(13, HIGH);
  digitalWrite(A3, 0); delay(100); Serial.println(); //turn on full power
  rtc.resetAlarm1(); //clear alarm flag
    
  Serial.print(F("Cycle: ")); Serial.println(cycles);
  printRTCTime(); //time updates here

  long rindex = h2000_now()-Start_H_Hour;
  Serial.print(F("EEPROM Index: ")); Serial.println(rindex);
  if(rindex>0){
    if(rindex<65535){
      Serial.println(F("WRITE"));
    }else{Serial.println(F("Clock>max!"));}
  }else{  Serial.println(F("Clock<min!"));}

  delay(100); digitalWrite(A3, 1); //turn off full power
  cycles++;

  digitalWrite(13, LOW);
  //*******************GO TO SLEEP and enable interrupt*********************
  ADCSRA = 0; //disable ADCS
  set_sleep_mode(SLEEP_MODE_PWR_DOWN); 
  sleep_enable();
  noInterrupts(); //stop any interrups before sleeping
  attachInterrupt(0, wake, FALLING); //goto 'wake' on interrupt 
  EIFR = bit(INTF0);  // clear flag for interrupt 0
  interrupts(); //start interrups and 
  sleep_cpu();  //then immediately sleep
}

void wake(){
  sleep_disable();
  detachInterrupt(0); //pin D2
}
